/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import javax.crypto.Cipher;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.ClickableLabelElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenCredits;
import net.minecraft.client.gui.ScreenPause;
import net.minecraft.client.gui.ScreenSelectServer;
import net.minecraft.client.gui.ScreenSelectWorld;
import net.minecraft.client.gui.error.ScreenMissingJCE;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.HudIngameDoom;
import net.minecraft.client.gui.options.ScreenOptions;
import net.minecraft.client.gui.options.data.OptionsPages;
import net.minecraft.client.holiday.Holidays;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.util.helper.UrlHelper;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import org.slf4j.Logger;

public class ScreenMainMenu
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Block<?>[] BLOCKS_TO_DRAW = new Block[]{Blocks.STONE, Blocks.DIRT, Blocks.PLANKS_OAK, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE_MOSSY, Blocks.BASALT, Blocks.LIMESTONE, Blocks.GRANITE, Blocks.BRICK_CLAY, Blocks.ICE, Blocks.WOOL, Blocks.BLOCK_SNOW, Blocks.OBSIDIAN, Blocks.COBBLE_NETHERRACK};
    private static String[] logoBlockLayers = null;
    private static final int[] KEY_CHAIN = new int[]{Keyboard.KEY_I, Keyboard.KEY_D, Keyboard.KEY_S, Keyboard.KEY_P, Keyboard.KEY_I, Keyboard.KEY_S, Keyboard.KEY_P, Keyboard.KEY_O, Keyboard.KEY_P, Keyboard.KEY_D, Keyboard.KEY_RETURN};
    private static final Random rand = new Random();
    private String splashText = "missingno";
    private ButtonElement multiplayerButton;
    private LogoBlock[][] logoBlocks;
    private Snowflake[] snowflakes = new Snowflake[50];
    private int logoClickCounter = 0;
    private int indexToDraw = 0;
    private int codeProgress = 0;
    private boolean showBuildTime = false;
    private String buildTimeString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(1750509510534L));
    private int snowfallTimer = 0;

    public ScreenMainMenu() {
        ScreenPause.photoModeDisabled = false;
        try (InputStream stream = ScreenMainMenu.class.getResourceAsStream("/assets/minecraft/textures/gui/title/splashes.txt");){
            String line;
            if (stream == null) {
                LOGGER.error("Could not locate 'splashes.txt'! Does the file exist!?");
                return;
            }
            ArrayList<String> allSplashes = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                allSplashes.add(line);
            }
            this.splashText = (String)allSplashes.get(rand.nextInt(allSplashes.size()));
        }
        catch (Exception e) {
            LOGGER.error("Failed to load splash texts!", e);
        }
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == KEY_CHAIN[this.codeProgress]) {
            ++this.codeProgress;
            if (this.codeProgress == KEY_CHAIN.length) {
                this.mc.hudIngame = this.mc.hudIngame instanceof HudIngameDoom ? new HudIngame(this.mc) : new HudIngameDoom(this.mc);
                this.mc.sndManager.playSound("mob.pig", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
                this.codeProgress = 0;
            }
        } else if (eventKey != -1) {
            this.codeProgress = 0;
        }
    }

    @Override
    public void init() {
        int i;
        I18n i18n = I18n.getInstance();
        for (i = 0; i < this.snowflakes.length; ++i) {
            this.snowflakes[i] = new Snowflake(rand.nextInt(this.width), rand.nextInt(this.height), 1 + rand.nextInt(4), this.height);
        }
        if (Holidays.ANNIVERSARY_JONKADELIC.isActive()) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.jonkadelic_birthday");
        } else if (Holidays.ANNIVERSARY_MAGGANDGEEZ.isActive()) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.maggandgeez_birthday");
        } else if (Holidays.ANNIVERSARY_MINECRAFT.isActive()) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.minecraft_birthday");
        } else if (Holidays.ANNIVERSARY_BTA.isActive()) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.bta_birthday");
        } else if (Holidays.XMAS.isActive()) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.xmas");
        } else if (Holidays.NEW_YEAR.isActive()) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.new_year");
        } else if (Holidays.HALLOWEEN.isActive()) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.halloween");
        }
        i = this.height / 4 + 48;
        this.buttons.add(new ButtonElement(1, this.width / 2 - 100, i, i18n.translateKey("gui.main_menu.button.singleplayer")));
        this.multiplayerButton = new ButtonElement(2, this.width / 2 - 100, i + 24, i18n.translateKey("gui.main_menu.button.multiplayer"));
        this.buttons.add(this.multiplayerButton);
        this.buttons.add(new ButtonElement(3, this.width / 2 - 100, i + 48, i18n.translateKey("gui.main_menu.button.texture_packs")));
        if (this.mc.hideQuitButton) {
            this.buttons.add(new ButtonElement(0, this.width / 2 - 100, i + 72, i18n.translateKey("gui.main_menu.button.options")));
        } else {
            this.buttons.add(new ButtonElement(0, this.width / 2 - 100, i + 72 + 12, 98, 20, i18n.translateKey("gui.main_menu.button.options")));
            this.buttons.add(new ButtonElement(4, this.width / 2 + 2, i + 72 + 12, 98, 20, i18n.translateKey("gui.main_menu.button.quit_game")));
        }
        int d = 1;
        this.buttons.add(new ClickableLabelElement(5, d, this.height - 48 - d, i18n.translateKey("gui.main_menu.button.credits"), 0x9F9F9F));
        this.buttons.add(new ClickableLabelElement(6, d, this.height - 36 - d, i18n.translateKey("gui.main_menu.button.website"), 5941560));
        this.buttons.add(new ClickableLabelElement(7, d, this.height - 24 - d, i18n.translateKey("gui.main_menu.button.discord"), 5793266));
        this.buttons.add(new ClickableLabelElement(8, d, this.height - 12 - d, i18n.translateKey("gui.main_menu.button.youtube"), 0xFF0000));
        this.buttons.add(new ButtonElement(9, this.width / 2 + 104, i + 72 + 12, 20, 20, "").setTextures("minecraft:gui/misc/button_language", "minecraft:gui/misc/button_language_highlighted", "minecraft:gui/misc/button_language"));
        ButtonElement debugButton = new ButtonElement(10, this.width - 8, this.height - 8, 8, 8, "");
        debugButton.visible = false;
        this.buttons.add(debugButton);
        this.buttons.add(new ButtonElement(11, this.width / 2 - 104 - 20, i + 72 + 12, 20, 20, "").setTextures("minecraft:gui/misc/button_support", "minecraft:gui/misc/button_support_highlighted", "minecraft:gui/misc/button_support"));
        if (this.mc.session == null) {
            this.multiplayerButton.enabled = false;
        }
    }

    @Override
    protected void buttonClicked(ButtonElement button) {
        switch (button.id) {
            case 0: {
                this.mc.displayScreen(new ScreenOptions(this));
                break;
            }
            case 1: {
                this.mc.displayScreen(new ScreenSelectWorld(this));
                break;
            }
            case 2: {
                boolean hasJCE;
                try {
                    hasJCE = Cipher.getMaxAllowedKeyLength("AES") > 128;
                }
                catch (Exception ignored) {
                    hasJCE = false;
                }
                if (!hasJCE && ((Boolean)this.mc.gameSettings.doJCECheck.value).booleanValue()) {
                    this.mc.displayScreen(new ScreenMissingJCE(this, new ScreenSelectServer(this)));
                    break;
                }
                this.mc.displayScreen(new ScreenSelectServer(this));
                break;
            }
            case 3: {
                this.mc.displayScreen(new ScreenOptions(this, OptionsPages.TEXTURE_PACKS));
                break;
            }
            case 4: {
                this.mc.shutdown();
                break;
            }
            case 5: {
                this.mc.displayScreen(new ScreenCredits(this));
                break;
            }
            case 6: {
                UrlHelper.openURL("https://betterthanadventure.net");
                break;
            }
            case 7: {
                UrlHelper.openURL("https://betterthanadventure.net/discord");
                break;
            }
            case 8: {
                UrlHelper.openURL("https://www.youtube.com/channel/UC_GT4t8Io87-UTzaGNnsuMg");
                break;
            }
            case 11: {
                UrlHelper.openURL("https://bugs.betterthanadventure.net/");
                break;
            }
            case 9: {
                this.mc.displayScreen(new ScreenOptions(this, OptionsPages.LANGUAGE));
                break;
            }
            case 10: {
                this.mc.displayScreen(new ScreenOptions(this, OptionsPages.DEBUG));
            }
        }
    }

    @Override
    public void renderTexturedBackground() {
        if (this.mc.mainMenuBackground.isEnabled() && !((Boolean)this.mc.gameSettings.alphaMenu.value).booleanValue()) {
            this.mc.mainMenuBackground.draw();
        } else {
            super.renderTexturedBackground();
        }
    }

    @Override
    public void tick() {
        for (Snowflake snowflake : this.snowflakes) {
            snowflake.updateEffects();
        }
        if (this.logoBlocks != null) {
            Snowflake[] snowflakeArray = this.logoBlocks;
            int n = snowflakeArray.length;
            for (int i = 0; i < n; ++i) {
                Snowflake logoBlock;
                for (Snowflake block : logoBlock = snowflakeArray[i]) {
                    ((LogoBlock)((Object)block)).updateLogoEffects();
                }
            }
        }
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        int logoWidth = 274;
        int logoX = this.width / 2 - logoWidth / 2;
        int logoHeight = 30;
        int p = 8;
        if (mx >= logoX + p && mx <= logoX + 270 - p && my >= logoHeight + p && my <= logoHeight + 48 - p) {
            if (this.logoClickCounter >= 0) {
                this.indexToDraw = rand.nextInt(BLOCKS_TO_DRAW.length);
                this.mc.gameSettings.alphaMenu.toggle();
                if (((Boolean)this.mc.gameSettings.alphaMenu.value).booleanValue()) {
                    this.logoBlocks = null;
                }
                this.logoClickCounter = 0;
            } else {
                ++this.logoClickCounter;
            }
        }
        if (my >= 2 && my <= 12 && mx >= 2 && mx <= 40) {
            this.showBuildTime = !this.showBuildTime;
        }
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        int versionTextColor;
        I18n i18n = I18n.getInstance();
        this.renderBackground();
        int c = 274;
        int k = this.width / 2 - c / 2;
        int byte0 = 30;
        if (!((Boolean)this.mc.gameSettings.alphaMenu.value).booleanValue()) {
            this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/title/mclogo.png").bind();
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.drawTexturedModalRect(k, byte0, 0, 0, 274, 50, 0.0036496350364963502, 0.02);
        } else {
            this.drawLogo(partialTick);
        }
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/title/snowflake.png").bind();
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (Holidays.getCurrentThemedHoliday() == Holidays.XMAS) {
            for (Snowflake snowflake : this.snowflakes) {
                this.drawTexturedModalRectDouble(snowflake.flakeX, snowflake.flakeY, 0.0, 4 * snowflake.texIndex, 4.0, 4.0, 0.25, 0.0625);
            }
        }
        GL11.glPushMatrix();
        GL11.glTranslatef(this.width / 2 + 140, 80.0f, 0.0f);
        GL11.glRotatef(-20.0f, 0.0f, 0.0f, 1.0f);
        float f1 = 1.8f - MathHelper.abs(MathHelper.sin((float)(System.currentTimeMillis() % 1000L) / 1000.0f * (float)Math.PI * 2.0f) * 0.1f);
        f1 = f1 * 100.0f / (float)(this.font.getStringWidth(this.splashText) + 32);
        GL11.glScalef(f1, f1, f1);
        this.drawStringCentered(this.font, this.splashText, 0, -8, 0xFFFF00);
        GL11.glPopMatrix();
        int n = versionTextColor = (Boolean)this.mc.gameSettings.alphaMenu.value != false || !this.mc.mainMenuBackground.isEnabled() ? 0x505050 : 0xFFFFFF;
        if (this.showBuildTime) {
            this.drawString(this.font, this.buildTimeString, 2, 2, versionTextColor);
        } else {
            this.drawString(this.font, "Better than Adventure! " + Minecraft.VERSION, 2, 2, versionTextColor);
        }
        String disclaimer1 = i18n.translateKey("gui.main_menu.label.disclaimer.1");
        this.drawString(this.font, disclaimer1, this.width - this.font.getStringWidth(disclaimer1) - 2, this.height - 20, 0xFFFFFF);
        String disclaimer2 = i18n.translateKey("gui.main_menu.label.disclaimer.2");
        this.drawString(this.font, disclaimer2, this.width - this.font.getStringWidth(disclaimer2) - 2, this.height - 10, 0xFFFFFF);
        super.render(mx, my, partialTick);
    }

    private void drawLogo(float var1) {
        int var3;
        if (this.logoBlocks == null) {
            this.logoBlocks = new LogoBlock[logoBlockLayers[0].length()][logoBlockLayers.length];
            for (int var2 = 0; var2 < this.logoBlocks.length; ++var2) {
                for (var3 = 0; var3 < this.logoBlocks[var2].length; ++var3) {
                    this.logoBlocks[var2][var3] = new LogoBlock(var2, var3);
                }
            }
        }
        GL11.glMatrixMode(5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        int delta = this.mc.gameWindow.getWidthPixels() / this.mc.resolution.getScaledWidthScreenCoords();
        var3 = 120 * delta;
        GLU.gluPerspective(70.0f, (float)this.mc.gameWindow.getWidthPixels() / (float)var3, 0.05f, 100.0f);
        GL11.glViewport(0, this.mc.gameWindow.getHeightPixels() - var3, this.mc.gameWindow.getWidthPixels(), var3);
        GL11.glMatrixMode(5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glDisable(2884);
        GL11.glCullFace(1029);
        GL11.glDepthMask(true);
        GL11.glEnable(2929);
        for (int var4 = 0; var4 < 3; ++var4) {
            GL11.glPushMatrix();
            GL11.glTranslatef(0.4f, 0.6f, -12.0f);
            if (var4 == 0) {
                GL11.glClear(256);
                GL11.glTranslatef(0.0f, -0.4f, 0.0f);
                GL11.glScalef(0.98f, 1.0f, 1.0f);
                GL11.glEnable(3042);
                GL11.glBlendFunc(770, 771);
            }
            if (var4 == 1) {
                GL11.glDisable(3042);
                GL11.glClear(256);
            }
            if (var4 == 2) {
                GL11.glEnable(3042);
                GL11.glBlendFunc(768, 1);
            }
            GL11.glScalef(1.0f, -1.0f, 1.0f);
            GL11.glRotatef(15.0f, 1.0f, 0.0f, 0.0f);
            GL11.glScalef(0.89f, 1.0f, 0.4f);
            GL11.glTranslatef((float)(-logoBlockLayers[0].length()) * 0.5f, (float)(-logoBlockLayers.length) * 0.5f, 0.0f);
            TextureRegistry.blockAtlas.bind();
            if (var4 == 0) {
                this.mc.textureManager.loadTexture("/title/black.png").bind();
            }
            RenderBlocks var5 = new RenderBlocks();
            for (int var6 = 0; var6 < logoBlockLayers.length; ++var6) {
                for (int var7 = 0; var7 < logoBlockLayers[var6].length(); ++var7) {
                    char var8 = logoBlockLayers[var6].charAt(var7);
                    if (var8 == ' ') continue;
                    GL11.glPushMatrix();
                    LogoBlock var9 = this.logoBlocks[var7][var6];
                    float var10 = (float)(var9.prevHeight + (var9.height - var9.prevHeight) * (double)var1);
                    float var11 = 1.0f;
                    float var12 = 1.0f;
                    if (var4 == 0) {
                        var11 = var10 * 0.04f + 1.0f;
                        var12 = 1.0f / var11;
                        var10 = 0.0f;
                    }
                    GL11.glTranslatef(var7, var6, var10);
                    GL11.glScalef(var11, var11, var11);
                    var5.renderBlockAsItem(Tessellator.instance, (BlockModel)BlockModelDispatcher.getInstance().getDispatch(BLOCKS_TO_DRAW[this.indexToDraw]), var12);
                    GL11.glPopMatrix();
                }
            }
            GL11.glPopMatrix();
        }
        GL11.glDisable(3042);
        GL11.glMatrixMode(5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode(5888);
        GL11.glPopMatrix();
        GL11.glViewport(0, 0, this.mc.gameWindow.getWidthPixels(), this.mc.gameWindow.getHeightPixels());
        GL11.glEnable(2884);
    }

    static Random getRandom() {
        return rand;
    }

    public static void loadLogo() {
        try {
            InputStream inputStream = ScreenMainMenu.class.getResourceAsStream("/assets/minecraft/textures/gui/title/retrologo.png");
            BufferedImage image = ImageIO.read(inputStream);
            inputStream.close();
            logoBlockLayers = new String[image.getHeight()];
            for (int i = 0; i < image.getHeight(); ++i) {
                StringBuilder builder = new StringBuilder();
                for (int j = 0; j < image.getWidth(); ++j) {
                    int rgb = image.getRGB(j, i);
                    if ((rgb >> 16 & 0xFF) > 128) {
                        builder.append('*');
                        continue;
                    }
                    builder.append(' ');
                }
                ScreenMainMenu.logoBlockLayers[i] = builder.toString();
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while loading retro logo!", e);
        }
    }

    static {
        ScreenMainMenu.loadLogo();
    }

    static class Snowflake {
        public double flakeX;
        private final double flakeXO;
        public double flakeY = -1.0;
        public double dropSpeed;
        public int maxHeight;
        private final double verticalSpeed;
        private final int texIndex;

        public Snowflake(int flakeX, int flakeY, int dropSpeed, int maxHeight) {
            this.flakeX = flakeX;
            this.flakeY = flakeY;
            this.flakeXO = flakeX;
            this.dropSpeed = dropSpeed;
            this.maxHeight = maxHeight;
            this.verticalSpeed = (double)rand.nextFloat() - 0.5;
            this.texIndex = rand.nextInt(4);
        }

        public void updateEffects() {
            this.flakeY += this.dropSpeed * (double)0.3f;
            this.flakeX += this.verticalSpeed * 1.5;
            if (this.flakeY > (double)this.maxHeight) {
                this.flakeY = 0.0;
                this.flakeX = this.flakeXO;
            }
        }
    }

    static class LogoBlock {
        public double height;
        public double prevHeight;
        public double dropSpeed;

        public LogoBlock(int var2, int var3) {
            this.height = this.prevHeight = (double)(10 + var3) + rand.nextDouble() * 32.0 + (double)var2;
        }

        public void updateLogoEffects() {
            this.prevHeight = this.height;
            if (this.height > 0.0) {
                this.dropSpeed -= 0.6;
            }
            this.height += this.dropSpeed;
            this.dropSpeed *= 0.9;
            if (this.height < 0.0) {
                this.height = 0.0;
                this.dropSpeed = 0.0;
            }
        }
    }
}

