/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.createworld;

import java.util.Random;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.MathHelper;

public class WorldConfig {
    private String name;
    private long seed;
    private Gamemode gamemode;
    private boolean cheatsEnabled;

    public WorldConfig(String name) {
        this.name = name;
        this.seed = new Random().nextLong();
        this.gamemode = Gamemode.survival;
        this.cheatsEnabled = false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setSeed(String seed) {
        if (!MathHelper.stringNullOrLengthZero(seed)) {
            try {
                long parsedSeed = Long.parseLong(seed);
                if (parsedSeed != 0L) {
                    this.seed = parsedSeed;
                }
            }
            catch (NumberFormatException e) {
                this.seed = seed.hashCode();
            }
        }
    }

    public Gamemode getGamemode() {
        return this.gamemode;
    }

    public void setGamemode(Gamemode gamemode) {
        this.gamemode = gamemode;
    }

    public boolean isCheatsEnabled() {
        return this.cheatsEnabled;
    }

    public void setCheatsEnabled(boolean cheatsEnabled) {
        this.cheatsEnabled = cheatsEnabled;
    }
}

