/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.crafting.displays;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.guidebook.SlotGuidebook;
import net.minecraft.client.gui.guidebook.crafting.displays.RecipeDisplayAdapter;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryLabel;
import net.minecraft.core.data.tag.ITaggable;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;

public class DisplayAdapterLabel
implements RecipeDisplayAdapter<RecipeEntryLabel> {
    protected static final IItemConvertible[] randomOptions;
    public static final String[] randomNames;

    @Override
    public List<SlotGuidebook> getSlots(RecipeEntryLabel recipe, int recipeAmount, int xOffset, int yOffset) {
        ArrayList<SlotGuidebook> recipeSlots = new ArrayList<SlotGuidebook>();
        ItemStack[] sharedBuffer = new ItemStack[2];
        RecipeSymbol[] symbols = new RecipeSymbol[]{new RecipeSymbol(Items.LABEL.getDefaultStack()), new RecipeSymbol(randomOptions[0].getDefaultStack()), null, null, new RecipeSymbol(randomOptions[0].getDefaultStack())};
        for (int i = 0; i < 4; ++i) {
            int x = 13 + 18 * (i % 2) + xOffset;
            int y = 10 + 18 * (i / 2 + recipeAmount * 3) + yOffset;
            SlotGuidebook slot = i == 0 ? new SlotGuidebookLabel(i, x, y, symbols[i], false, recipe, sharedBuffer) : (i == 1 ? new SlotGuidebookUnnamedInput(i, x, y, symbols[i], false, recipe, sharedBuffer) : new SlotGuidebook(i, x, y, symbols[i], false, recipe));
            recipeSlots.add(slot);
        }
        int centerY = (((SlotGuidebook)recipeSlots.get((int)(recipeSlots.size() - 1))).y + ((SlotGuidebook)recipeSlots.get((int)(recipeSlots.size() - 3))).y) / 2;
        recipeSlots.add(new SlotGuidebookNamedOutput(symbols.length - 1, 81 + xOffset, centerY, symbols[4], false, recipe, sharedBuffer).setAsOutput());
        return recipeSlots;
    }

    static {
        ITaggable<Block<?>> b;
        randomOptions = new IItemConvertible[100];
        randomNames = new String[]{"Useless", "Bob", "Steve", "Adam", "Lucas", "George", "Ferdinand", "Hemingway", "Greg", "Brian", "Fells", "Herobrine"};
        int blocksAdded = 0;
        int lastId = 0;
        int offset = 1;
        while (blocksAdded < 50) {
            b = null;
            while (b == null) {
                b = Blocks.getBlock(lastId + offset++);
            }
            DisplayAdapterLabel.randomOptions[blocksAdded++] = b;
            lastId = b.id();
            offset = 1;
        }
        int itemsAdded = 0;
        lastId = 0;
        offset = 1;
        while (itemsAdded < 50) {
            b = null;
            while (b == null) {
                b = Item.getItem(lastId + offset++);
            }
            DisplayAdapterLabel.randomOptions[50 + itemsAdded++] = b;
            lastId = ((Item)b).id;
            offset = 1;
        }
    }

    public static class SlotGuidebookLabel
    extends SlotGuidebook {
        private final ItemStack[] itemBuffer;

        public SlotGuidebookLabel(int id, int x, int y, RecipeSymbol symbol, boolean discovered, RecipeEntryBase<?, ?, ?> recipe, ItemStack[] itemBuffer) {
            super(id, x, y, symbol, discovered, recipe);
            this.itemBuffer = itemBuffer;
        }

        @Override
        public void showRandomItem() {
            Random r = new Random();
            this.itemBuffer[0] = this.item = new ItemStack(Items.LABEL);
            this.item.setCustomName(randomNames[r.nextInt(randomNames.length)]);
        }
    }

    public static class SlotGuidebookUnnamedInput
    extends SlotGuidebook {
        private final ItemStack[] itemBuffer;

        public SlotGuidebookUnnamedInput(int id, int x, int y, RecipeSymbol symbol, boolean discovered, RecipeEntryBase<?, ?, ?> recipe, ItemStack[] itemBuffer) {
            super(id, x, y, symbol, discovered, recipe);
            this.itemBuffer = itemBuffer;
        }

        @Override
        public void showRandomItem() {
            Random r = new Random();
            this.itemBuffer[1] = this.item = randomOptions[r.nextInt(randomOptions.length)].getDefaultStack();
        }
    }

    public static class SlotGuidebookNamedOutput
    extends SlotGuidebook {
        private final ItemStack[] itemBuffer;

        public SlotGuidebookNamedOutput(int id, int x, int y, RecipeSymbol symbol, boolean discovered, RecipeEntryBase<?, ?, ?> recipe, ItemStack[] itemBuffer) {
            super(id, x, y, symbol, discovered, recipe);
            this.itemBuffer = itemBuffer;
        }

        @Override
        public void showRandomItem() {
            this.item = new ItemStack(this.itemBuffer[1]);
            this.item.setCustomName(this.itemBuffer[0].getCustomName());
            this.item.setCustomColor(this.itemBuffer[0].getCustomColor());
        }
    }
}

