/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.subtitles;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.sound.SoundEvent;
import net.minecraft.core.entity.Entity;

public class SubtitleTracker {
    public static final int SUBTITLE_LIFETIME_MS = 5000;
    public final Map<SoundEvent, SubtitleEntry> entryMap = new LinkedHashMap<SoundEvent, SubtitleEntry>();
    private static final List<SoundEvent> removalQueue = new ArrayList<SoundEvent>();

    public void heardSound(SoundEvent event, double x, double y, double z) {
        if (this.entryMap.containsKey(event)) {
            this.entryMap.get(event).wasHeard(event, x, y, z);
        } else {
            this.entryMap.put(event, new SubtitleEntry(event, x, y, z));
        }
    }

    public void tick() {
        long currentTime = System.currentTimeMillis();
        for (SubtitleEntry e : this.entryMap.values()) {
            if (currentTime - e.lastHeardTime <= 5000L) continue;
            removalQueue.add(e.soundEvent);
        }
        removalQueue.forEach(this.entryMap::remove);
        removalQueue.clear();
    }

    public void clear() {
        this.entryMap.clear();
    }

    public static class SubtitleEntry {
        public double sourceX;
        public double sourceY;
        public double sourceZ;
        public SoundEvent soundEvent;
        public long lastHeardTime;

        public SubtitleEntry(SoundEvent event, double x, double y, double z) {
            this.wasHeard(event, x, y, z);
        }

        public void wasHeard(SoundEvent event, double x, double y, double z) {
            this.sourceX = x;
            this.sourceY = y;
            this.sourceZ = z;
            this.soundEvent = event;
            this.lastHeardTime = System.currentTimeMillis();
        }

        public float getFadeout() {
            return (float)(System.currentTimeMillis() - this.lastHeardTime) / 5000.0f;
        }

        public double getRelativeAngle(Entity listener) {
            if (listener == null) {
                return Double.NaN;
            }
            double angle = Math.atan2(this.sourceZ - listener.z, this.sourceX - listener.x);
            return angle - Math.toRadians(listener.yRot);
        }
    }
}

