/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicFarmland;
import net.minecraft.core.util.helper.Side;

public class BlockModelFarmland<T extends BlockLogic>
extends BlockModelStandard<T> {
    protected IconCoordinate topWet = TextureRegistry.getTexture("minecraft:block/farmland/wet_top");
    protected IconCoordinate topWetFertilized = TextureRegistry.getTexture("minecraft:block/farmland/wet_fertilized_top");
    protected IconCoordinate topDry = TextureRegistry.getTexture("minecraft:block/farmland/dry_top");
    protected IconCoordinate topDryFertilized = TextureRegistry.getTexture("minecraft:block/farmland/dry_fertilized_top");
    protected IconCoordinate mud = TextureRegistry.getTexture("minecraft:block/farmland/wet");

    public BlockModelFarmland(Block<T> block) {
        super(block);
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        boolean isWet = BlockLogicFarmland.isWet(data);
        boolean isFertilized = BlockLogicFarmland.isFertilized(data);
        if (side == Side.TOP) {
            if (isWet && isFertilized) {
                return this.topWetFertilized;
            }
            if (isWet) {
                return this.topWet;
            }
            if (isFertilized) {
                return this.topDryFertilized;
            }
            return this.topDry;
        }
        if (isWet) {
            return this.mud;
        }
        return super.getBlockTextureFromSideAndMetadata(side, data);
    }
}

