/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.item.Item;
import org.lwjgl.opengl.GL11;

public class EntityRendererSprite<T extends Entity>
extends EntityRenderer<T> {
    private IconCoordinate itemIconIndex;
    private float scale = 1.0f;
    private boolean fullBright = false;

    public EntityRendererSprite(Item item) {
        this(((ItemModel)ItemModelDispatcher.getInstance().getDispatch(item)).getIcon(null, item.getDefaultStack()));
    }

    public EntityRendererSprite(IconCoordinate i) {
        this.itemIconIndex = i;
    }

    public EntityRendererSprite<T> setFullBright() {
        this.fullBright = true;
        return this;
    }

    public EntityRendererSprite<T> setScale(float scale) {
        this.scale = scale;
        return this;
    }

    @Override
    public void render(Tessellator tessellator, T entity, double x, double y, double z, float yaw, float partialTick) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        if (this.fullBright) {
            GL11.glDisable(2896);
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            if (LightmapHelper.isLightmapEnabled()) {
                LightmapHelper.setLightmapCoord(LightmapHelper.getLightmapCoord(15, 15));
            }
        }
        GL11.glEnable(32826);
        GL11.glScalef(0.5f * this.scale, 0.5f * this.scale, 0.5f * this.scale);
        this.itemIconIndex.parentAtlas.bind();
        float f2 = (float)this.itemIconIndex.getIconUMin();
        float f3 = (float)this.itemIconIndex.getIconUMax();
        float f4 = (float)this.itemIconIndex.getIconVMin();
        float f5 = (float)this.itemIconIndex.getIconVMax();
        float f6 = 1.0f;
        float f7 = 0.5f;
        float f8 = 0.25f;
        GL11.glRotatef(180.0f - this.renderDispatcher.viewLerpYaw, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(-this.renderDispatcher.viewLerpPitch, 1.0f, 0.0f, 0.0f);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        tessellator.addVertexWithUV(0.0f - f7, 0.0f - f8, 0.0, f2, f5);
        tessellator.addVertexWithUV(f6 - f7, 0.0f - f8, 0.0, f3, f5);
        tessellator.addVertexWithUV(f6 - f7, 1.0f - f8, 0.0, f3, f4);
        tessellator.addVertexWithUV(0.0f - f7, 1.0f - f8, 0.0, f2, f4);
        tessellator.draw();
        GL11.glDisable(32826);
        GL11.glPopMatrix();
        if (this.fullBright) {
            GL11.glEnable(2896);
        }
    }
}

