/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.font;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.font.FontFile;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import org.jetbrains.annotations.NotNull;

public class FontDefault
extends FontFile {
    public FontDefault(@NotNull String key) {
        super(key, "/assets/minecraft/textures/gui/font/default/font_%02X.png", "/assets/minecraft/textures/gui/font/default/glyph_sizes.bin");
    }

    @Override
    public boolean canRenderChar(char c) {
        return c == ' ' || !DEFAULT_BLACKLIST.contains(Character.valueOf(c)) && ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c) >= 0 && this.textureForChar(c) != 0;
    }

    @Override
    public int textureForChar(char c) {
        int fontIndex = ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c);
        if (fontIndex < 0) {
            return 0;
        }
        int index = fontIndex / 256;
        if (this.texHandleCache[index] != -1) {
            return this.texHandleCache[index];
        }
        Texture texture = Minecraft.getMinecraft().textureManager.loadTextureNoDefault(String.format(this.textureFormat, index));
        if (texture == null) {
            this.texHandleCache[index] = 0;
            return 0;
        }
        this.texHandleCache[index] = texture.id();
        return texture.id();
    }

    @Override
    public double charWidthDouble(char c) {
        if (c == ' ') {
            return 4.0;
        }
        int fontIndex = ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c);
        if (fontIndex < 0) {
            return 0.0;
        }
        int upper = this.charWidth[fontIndex] >> 4;
        int lower = this.charWidth[fontIndex] & 0xF;
        double fUpper = upper;
        double fLower = lower + 1;
        return (fLower - fUpper) / 2.0 + 1.0;
    }

    @Override
    public double renderChar(Tessellator tessellator, char c, double x, double y, double z, boolean italics) {
        if (c == ' ') {
            return 4.0;
        }
        int fontIndex = ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c);
        if (fontIndex < 0) {
            return 0.0;
        }
        boolean shift = italics;
        int lower = this.charWidth[fontIndex] & 0xF;
        double fLower = lower + 1;
        int upper = this.charWidth[fontIndex] >> 4;
        double fUpper = upper;
        if (fLower - fUpper == 0.0) {
            return 0.0;
        }
        double epsilon = 7.8125E-5;
        double u = (double)(fontIndex % 16 * 16) + fUpper;
        double v = (fontIndex & 0xFF) / 16 * 16;
        double uWidth = fLower - fUpper;
        double vHeight = 16.0;
        double uMin = u / 256.0;
        double uMax = (u + uWidth) / 256.0;
        double vMin = v / 256.0;
        double vMax = (v + 16.0) / 256.0;
        double width = uWidth / 2.0;
        double height = 8.0;
        tessellator.addVertexWithUV(x + (double)shift, y, z, uMin + 7.8125E-5, vMin + 7.8125E-5);
        tessellator.addVertexWithUV(x - (double)shift, y + 8.0, z, uMin + 7.8125E-5, vMax - 7.8125E-5);
        tessellator.addVertexWithUV(x - (double)shift + width, y + 8.0, z, uMax - 7.8125E-5, vMax - 7.8125E-5);
        tessellator.addVertexWithUV(x + (double)shift + width, y, z, uMax - 7.8125E-5, vMin + 7.8125E-5);
        return (fLower - fUpper) / 2.0 + 1.0;
    }
}

