/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.font;

import java.util.Arrays;
import net.minecraft.client.render.font.FontFile;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texturepack.TexturePackList;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import org.jetbrains.annotations.NotNull;

public class FontMonospace
extends FontFile {
    public static final int MONOSPACE_WIDTH = 10;

    public FontMonospace(@NotNull String key) {
        super(key, "/assets/minecraft/textures/gui/font/monospace/mono_%02X.png", "");
    }

    @Override
    public void init(@NotNull TexturePackList packList) {
        Arrays.fill(this.texHandleCache, -1);
        Arrays.fill(this.charWidth, (byte)10);
    }

    @Override
    public boolean canRenderChar(char c) {
        return !DEFAULT_BLACKLIST.contains(Character.valueOf(c)) && ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c) != -1 && (c == ' ' || this.textureForChar(c) != 0);
    }

    @Override
    public double charWidthDouble(char c) {
        return 6.0;
    }

    @Override
    public double renderChar(Tessellator tessellator, char c, double x, double y, double z, boolean italics) {
        if (c != ' ') {
            boolean shift = italics;
            int fontIndex = ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c);
            if (fontIndex < 0) {
                return 0.0;
            }
            double epsilon = 7.8125E-5;
            int upper = this.charWidth[fontIndex] >> 4;
            int lower = this.charWidth[fontIndex] & 0xF;
            double fUpper = upper;
            double fLower = lower + 1;
            double u = (double)(fontIndex % 16 * 16) + fUpper;
            double v = (fontIndex & 0xFF) / 16 * 16;
            double uWidth = fLower - fUpper;
            double vHeight = 16.0;
            double uMin = u / 256.0;
            double uMax = (u + uWidth) / 256.0;
            double vMin = v / 256.0;
            double vMax = (v + 16.0) / 256.0;
            double width = uWidth / 2.0;
            double height = 8.0;
            tessellator.addVertexWithUV(x + (double)shift, y, z, uMin + 7.8125E-5, vMin + 7.8125E-5);
            tessellator.addVertexWithUV(x - (double)shift, y + 8.0, z, uMin + 7.8125E-5, vMax - 7.8125E-5);
            tessellator.addVertexWithUV(x - (double)shift + width, y + 8.0, z, uMax - 7.8125E-5, vMax - 7.8125E-5);
            tessellator.addVertexWithUV(x + (double)shift + width, y, z, uMax - 7.8125E-5, vMin + 7.8125E-5);
        }
        return 6.0;
    }
}

