/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.font;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.render.font.Font;
import net.minecraft.client.render.font.FontDefault;
import net.minecraft.client.render.font.FontMonospace;
import net.minecraft.client.render.font.FontUnicode;
import net.minecraft.client.render.texturepack.TexturePackList;
import org.jetbrains.annotations.NotNull;

public class Fonts {
    @NotNull
    private static final List<Font> permanentFonts = new ArrayList<Font>();
    @NotNull
    private static final List<Font> availableFonts = new ArrayList<Font>();
    @NotNull
    private static final @NotNull Map<@NotNull String, @NotNull Font> fontMap = new HashMap<String, Font>();
    public static final Font DEFAULT = Fonts.registerFont(new FontDefault("default"), true);
    public static final Font MONOSPACE = Fonts.registerFont(new FontMonospace("monospace"), true);
    public static final Font UNICODE = Fonts.registerFont(new FontUnicode("unicode"), true);

    @NotNull
    public static Font registerFont(@NotNull Font font, boolean permanent) {
        fontMap.put(font.getKey(), font);
        if (permanent && !permanentFonts.contains(font)) {
            permanentFonts.add(font);
        }
        if (!availableFonts.contains(font)) {
            availableFonts.add(font);
        }
        return font;
    }

    public static void refreshFonts(@NotNull TexturePackList texturePackList) {
        fontMap.clear();
        availableFonts.clear();
        availableFonts.addAll(permanentFonts);
        for (Font font2 : availableFonts) {
            Fonts.registerFont(font2, false);
        }
        fontMap.values().forEach(font -> font.init(texturePackList));
    }

    public static int fontAmount() {
        return availableFonts.size();
    }

    @NotNull
    public static Font fontAtIndex(int index) {
        if (index < 0 || index >= availableFonts.size()) {
            return DEFAULT;
        }
        return availableFonts.get(index);
    }

    public static int indexForFont(@NotNull Font font) {
        return availableFonts.indexOf(font);
    }

    @NotNull
    public static Font fontWithKey(@NotNull String key) {
        return fontMap.getOrDefault(key, DEFAULT);
    }
}

