/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.terrain;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.render.terrain.VertexBuffer;
import net.minecraft.client.render.terrain.VertexConfig;
import net.minecraft.client.render.terrain.VertexData;
import net.minecraft.core.util.helper.Buffer;
import org.lwjgl.opengl.GL15;

public class RenderList {
    public final VertexBuffer vertexBuffer;
    private VertexConfig vertexConfig;
    private boolean vertexConfigLocked = false;
    private IntBuffer posBuffer;
    private IntBuffer sizeBuffer;
    private List<VertexBuffer.Entry> entryList = new ArrayList<VertexBuffer.Entry>();
    private Set<VertexBuffer.Entry> visibleEntries = new HashSet<VertexBuffer.Entry>();
    private boolean visibleEntriesUpdated = true;

    public RenderList(VertexBuffer vertexBuffer, int capacity) {
        this.vertexBuffer = vertexBuffer;
        this.posBuffer = Buffer.createBuffer(capacity * 4).asIntBuffer();
        this.sizeBuffer = Buffer.createBuffer(capacity * 4).asIntBuffer();
    }

    public void draw() {
        if (this.entryList.size() == 0) {
            return;
        }
        if (this.visibleEntriesUpdated) {
            int vertexSize = this.vertexConfig.getVertexSize();
            this.posBuffer = RenderList.expandIfNecessary(this.posBuffer, this.visibleEntries.size());
            this.sizeBuffer = RenderList.expandIfNecessary(this.sizeBuffer, this.visibleEntries.size());
            this.posBuffer.clear();
            this.sizeBuffer.clear();
            for (VertexBuffer.Entry entry : this.visibleEntries) {
                this.posBuffer.put(entry.position / vertexSize);
                this.sizeBuffer.put(entry.size / vertexSize);
            }
            this.posBuffer.flip();
            this.sizeBuffer.flip();
            this.visibleEntriesUpdated = false;
        }
        if (this.visibleEntries.size() == 0) {
            return;
        }
        GL15.glMultiDrawArrays(this.vertexConfig.drawMode, this.posBuffer, this.sizeBuffer);
    }

    public VertexBuffer.Entry add(VertexData vertexData, boolean visible) {
        if (vertexData.vertexCount <= 0) {
            return null;
        }
        if (this.entryList.size() == 0 && !this.vertexConfigLocked) {
            this.vertexConfig = vertexData.config.copy();
        } else {
            VertexConfig.compareThrow(this.vertexConfig, vertexData.config);
        }
        VertexBuffer.Entry entry = this.vertexBuffer.addVertexData(vertexData);
        this.entryList.add(entry);
        if (visible) {
            this.visibleEntries.add(entry);
            this.visibleEntriesUpdated = true;
        }
        return entry;
    }

    public void setVisible(VertexBuffer.Entry entry, boolean visible) {
        if (entry == null) {
            throw new NullPointerException();
        }
        if (visible) {
            if (this.visibleEntries.add(entry)) {
                this.visibleEntriesUpdated = true;
            }
        } else if (this.visibleEntries.remove(entry)) {
            this.visibleEntriesUpdated = true;
        }
    }

    public void lockVertexConfig(VertexConfig vertexConfig) {
        if (vertexConfig == null) {
            throw new NullPointerException("VertexConfig cannot be null!");
        }
        if (this.entryList.size() > 0 && !this.vertexConfig.equals(vertexConfig)) {
            VertexConfig.compareThrow(this.vertexConfig, vertexConfig);
        }
        this.vertexConfig = vertexConfig.copy();
        this.vertexConfigLocked = true;
    }

    public boolean remove(VertexBuffer.Entry entry) {
        if (this.entryList.remove(entry)) {
            this.vertexBuffer.removeEntry(entry);
            this.visibleEntries.remove(entry);
            this.visibleEntriesUpdated = true;
            return true;
        }
        return false;
    }

    public int size() {
        return this.entryList.size();
    }

    public int visibleEntryCount() {
        return this.visibleEntries.size();
    }

    public VertexConfig getVertexConfig() {
        return this.vertexConfig;
    }

    public boolean isVertexConfigLocked() {
        return this.vertexConfigLocked;
    }

    public static IntBuffer expandIfNecessary(IntBuffer buffer, int requiredCapacity) {
        if (buffer.capacity() < requiredCapacity) {
            int newCapacity = Math.max(buffer.capacity() * 2, requiredCapacity);
            System.out.println("Expand RenderList IntBuffer " + buffer.capacity() + " -> " + newCapacity);
            return Buffer.createBuffer(newCapacity << 2).asIntBuffer();
        }
        return buffer;
    }
}

