/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texturepack;

import com.b100.json.JsonParser;
import com.b100.json.element.JsonElement;
import com.b100.json.element.JsonObject;
import com.b100.utils.InvalidCharacterException;
import com.b100.utils.StringUtils;
import java.io.File;
import java.io.InputStream;
import net.minecraft.client.render.texturepack.ManifestBase;

public class Manifest
extends ManifestBase {
    private final String name;
    private final String line1;
    private final String line2;
    private final String packVersion;
    private final int format;

    public Manifest(File texturePackFile, InputStream stream) {
        JsonObject rootObject;
        String string = StringUtils.readInputString(stream);
        if (string.length() == 0) {
            throw new ManifestException("File is empty!");
        }
        try {
            rootObject = JsonParser.instance.parseString(string);
        }
        catch (InvalidCharacterException e) {
            throw new ManifestException("Json Error at line " + e.getLine() + " column " + e.getColumn(), e);
        }
        catch (Exception e) {
            throw new ManifestException("Json Error", e);
        }
        JsonElement descriptionElement = rootObject.get("description");
        if (descriptionElement == null) {
            throw new ManifestException("Missing \"description\" Object!");
        }
        if (!descriptionElement.isObject()) {
            throw new ManifestException("\"description\" must be an Object!");
        }
        JsonObject description = descriptionElement.getAsObject();
        JsonElement name = description.get("name");
        JsonElement line1 = description.get("line1");
        JsonElement line2 = description.get("line2");
        JsonElement packVersion = description.get("packVersion");
        JsonElement format = description.get("format");
        this.name = name != null && name.isString() ? name.getAsString().value : texturePackFile.getName();
        this.line1 = line1 != null ? line1.getAsString().value : "";
        this.line2 = line2 != null ? line2.getAsString().value : "";
        if (packVersion != null) {
            if (!packVersion.isString()) {
                throw new ManifestException("\"packVersion\" must be a String!");
            }
        } else {
            throw new ManifestException("Missing \"packVersion\" String!");
        }
        this.packVersion = packVersion.getAsString().value;
        if (format != null) {
            if (!format.isNumber()) {
                throw new ManifestException("\"format\" must be an Integer!");
            }
        } else {
            throw new ManifestException("Missing \"format\" Integer!");
        }
        this.format = format.getAsNumber().getInteger();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescriptionLine1() {
        return this.line1;
    }

    @Override
    public String getDescriptionLine2() {
        return this.line2;
    }

    @Override
    public String getPackVersion() {
        return this.packVersion;
    }

    @Override
    public int getFormat() {
        return this.format;
    }

    public static class ManifestException
    extends RuntimeException {
        public ManifestException(String msg, Throwable throwable) {
            super(msg, throwable);
        }

        public ManifestException(String msg) {
            super(msg);
        }
    }
}

