/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.window;

import com.github.zarzelcow.legacylwjgl3.implementation.glfw.GLFWKeyboardImplementation;
import com.github.zarzelcow.legacylwjgl3.implementation.glfw.GLFWMouseImplementation;
import com.github.zarzelcow.legacylwjgl3.implementation.input.CombinedInputImplementation;
import com.github.zarzelcow.legacylwjgl3.implementation.input.InputImplementation;
import com.mojang.logging.LogUtils;
import java.awt.Dimension;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Objects;
import javax.swing.JFrame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.PanelCrashReport;
import net.minecraft.client.render.window.GameWindow;
import net.minecraft.core.Global;
import net.minecraft.core.UnexpectedThrowable;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL;
import org.lwjgl.stb.STBImage;
import org.slf4j.Logger;

public class GameWindowGLFW
implements GameWindow {
    private static final Logger LOGGER = LogUtils.getLogger();
    public Minecraft mc;
    public long window;
    private boolean wasResized = false;
    private boolean isFullscreen = false;
    private boolean hasFocus = true;
    private int windowPosX;
    private int windowPosY;
    private int windowWidth;
    private int windowHeight;
    private int widthScreenCoords;
    private int heightScreenCoords;
    private int widthPixels;
    private int heightPixels;
    private static ByteBuffer buffer = BufferUtils.createByteBuffer(0x100000);

    @Override
    public void init(Minecraft minecraft, int width, int height) {
        block5: {
            this.mc = minecraft;
            System.out.println("GLFW Init");
            if (!GLFW.glfwInit()) {
                throw new RuntimeException("GLFW Init failed!");
            }
            GLFW.glfwWindowHint(131075, 1);
            GLFW.glfwWindowHint(131076, 0);
            GLFW.glfwWindowHint(131078, 1);
            GLFW.glfwWindowHint(131077, 1);
            this.window = GLFW.glfwCreateWindow(width, height, "Better than Adventure! " + Global.VERSION, 0L, 0L);
            int[] w = new int[1];
            int[] h = new int[1];
            GLFW.glfwGetWindowSize(this.window, w, h);
            this.widthScreenCoords = w[0];
            this.heightScreenCoords = h[0];
            GLFW.glfwGetFramebufferSize(this.window, w, h);
            this.widthPixels = w[0];
            this.heightPixels = h[0];
            MonitorInfo monitor = new MonitorInfo(GLFW.glfwGetPrimaryMonitor());
            GLFW.glfwSetWindowPos(this.window, (monitor.widthScreenCoords - this.widthScreenCoords) / 2, (monitor.heightScreenCoords - this.heightScreenCoords) / 2);
            GLFW.glfwSetWindowSizeCallback(this.window, (window, ww, hh) -> {
                this.widthScreenCoords = Math.max(1, ww);
                this.heightScreenCoords = Math.max(1, hh);
                this.wasResized = true;
            });
            GLFW.glfwSetFramebufferSizeCallback(this.window, (window, ww, hh) -> {
                this.widthPixels = Math.max(1, ww);
                this.heightPixels = Math.max(1, hh);
                this.wasResized = true;
            });
            GLFW.glfwSetWindowFocusCallback(this.window, (window, focused) -> {
                this.hasFocus = focused;
                if (Mouse.isGrabbed() && !focused) {
                    Mouse.setGrabbed(false);
                }
            });
            int[] resolutions = new int[]{16, 32, 64, 128, 256};
            GLFWImage.Buffer gb = GLFWImage.create(resolutions.length);
            for (int i = 0; i < resolutions.length; ++i) {
                int res = resolutions[i];
                ByteBuffer icon = GameWindowGLFW.getImageBuffer("/icon/" + res + ".png");
                if (icon == null) {
                    LOGGER.error("Icon at resolution '{}' is null! Skipping icons!", (Object)res);
                    gb.close();
                    break block5;
                }
                GLFWImage iconGI = GLFWImage.create().set(res, res, icon);
                gb.put(i, iconGI);
            }
            GLFW.glfwSetWindowIcon(this.window, gb);
        }
        GLFW.glfwShowWindow(this.window);
        GLFW.glfwMakeContextCurrent(this.window);
        GL.createCapabilities();
        Display.setWindow(this);
        try {
            Method createKeyboard = Keyboard.class.getDeclaredMethod("create", InputImplementation.class);
            createKeyboard.setAccessible(true);
            Method createMouse = Mouse.class.getDeclaredMethod("create", InputImplementation.class);
            createMouse.setAccessible(true);
            GLFWKeyboardImplementation keyboardImplementation = new GLFWKeyboardImplementation();
            GLFWMouseImplementation mouseImplementation = new GLFWMouseImplementation();
            CombinedInputImplementation inputImplementation = new CombinedInputImplementation(keyboardImplementation, mouseImplementation);
            createKeyboard.invoke(null, inputImplementation);
            createMouse.invoke(null, inputImplementation);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.setVsync((Boolean)this.mc.gameSettings.enableVsync.value);
    }

    @Override
    public void toggleFullscreen() {
        this.mc.gameSettings.fullscreen.value = (Boolean)this.mc.gameSettings.fullscreen.value == false;
        this.updateWindowState();
    }

    @Override
    public void updateWindowState() {
        if (!this.isFullscreen) {
            int[] x = new int[1];
            int[] y = new int[1];
            GLFW.glfwGetWindowPos(this.window, x, y);
            int[] w = new int[1];
            int[] h = new int[1];
            GLFW.glfwGetWindowSize(this.window, w, h);
            this.windowPosX = x[0];
            this.windowPosY = y[0];
            this.windowWidth = w[0];
            this.windowHeight = h[0];
        }
        boolean fullscreen = (Boolean)this.mc.gameSettings.fullscreen.value;
        boolean borderless = (Boolean)this.mc.gameSettings.borderlessFullscreen.value;
        GLFW.glfwHideWindow(this.window);
        if (fullscreen && !borderless) {
            System.out.println("Change to Fullscreen");
            int x = this.windowPosX + this.windowWidth / 2;
            int y = this.windowPosY + this.windowHeight / 2;
            MonitorInfo monitor = this.getMonitorAt(x, y);
            GLFW.glfwSetWindowMonitor(this.window, monitor.handle, monitor.posX, monitor.posY, monitor.widthScreenCoords, monitor.heightScreenCoords, monitor.refreshRate);
            this.isFullscreen = true;
        } else {
            GLFW.glfwSetWindowMonitor(this.window, 0L, this.windowPosX, this.windowPosY, this.windowWidth, this.windowHeight, 0);
            if (fullscreen && borderless) {
                System.out.println("Change to Borderless Fullscreen");
                int x = this.windowPosX + this.windowWidth / 2;
                int y = this.windowPosY + this.windowHeight / 2;
                MonitorInfo monitor = this.getMonitorAt(x, y);
                GLFW.glfwSetWindowAttrib(this.window, 131077, 0);
                GLFW.glfwSetWindowPos(this.window, monitor.posX, monitor.posY);
                GLFW.glfwSetWindowSize(this.window, monitor.widthScreenCoords, monitor.heightScreenCoords);
                this.isFullscreen = true;
            } else {
                System.out.println("Change to Windowed");
                GLFW.glfwSetWindowAttrib(this.window, 131077, 1);
                this.isFullscreen = false;
            }
        }
        GLFW.glfwShowWindow(this.window);
    }

    public MonitorInfo getMonitorAt(int x, int y) {
        PointerBuffer monitorPointers = GLFW.glfwGetMonitors();
        for (int i = monitorPointers.position(); i < monitorPointers.limit(); ++i) {
            long monitor = monitorPointers.get(i);
            MonitorInfo info = new MonitorInfo(monitor);
            if (x < info.posX || y < info.posY || x >= info.posX + info.widthScreenCoords || y >= info.posY + info.heightScreenCoords) continue;
            return info;
        }
        return new MonitorInfo(GLFW.glfwGetPrimaryMonitor());
    }

    @Override
    public void displayCrashReport(UnexpectedThrowable unexpectedThrowable, int cause) {
        JFrame frame = new JFrame();
        PanelCrashReport panel = new PanelCrashReport(this.mc, unexpectedThrowable, cause);
        panel.setPreferredSize(new Dimension(1280, 720));
        frame.add(panel);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }

    @Override
    public int getFrequency() {
        GLFWVidMode vidMode;
        long monitor = GLFW.glfwGetWindowMonitor(this.window);
        if (monitor != 0L && (vidMode = GLFW.glfwGetVideoMode(monitor)) != null) {
            return vidMode.refreshRate();
        }
        int x = this.windowPosX + this.windowWidth / 2;
        int y = this.windowPosY + this.windowHeight / 2;
        MonitorInfo info = this.getMonitorAt(x, y);
        return info.refreshRate;
    }

    @Override
    public void update() {
        GLFW.glfwPollEvents();
        if (this.isFocused()) {
            Keyboard.poll();
        }
        Mouse.poll();
        GLFW.glfwSwapBuffers(this.window);
    }

    @Override
    public boolean shouldClose() {
        return GLFW.glfwWindowShouldClose(this.window);
    }

    @Override
    public int getWidthScreenCoords() {
        return this.widthScreenCoords;
    }

    @Override
    public int getHeightScreenCoords() {
        return this.heightScreenCoords;
    }

    @Override
    public int getWidthPixels() {
        return this.widthPixels;
    }

    @Override
    public int getHeightPixels() {
        return this.heightPixels;
    }

    @Override
    public boolean isFocused() {
        return this.hasFocus;
    }

    @Override
    public boolean wasResized() {
        if (this.wasResized) {
            this.wasResized = false;
            return true;
        }
        return false;
    }

    @Override
    public void setVsync(boolean vsync) {
        if (vsync) {
            GLFW.glfwSwapInterval(1);
        } else {
            GLFW.glfwSwapInterval(0);
        }
    }

    @Override
    public long getHandle() {
        return this.window;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ByteBuffer getImageBuffer(String resource) {
        try (InputStream stream = GameWindowGLFW.class.getResourceAsStream(resource);){
            int value;
            if (stream == null) {
                LOGGER.error("No icon could be found at '{}'!", (Object)resource);
                ByteBuffer byteBuffer2 = null;
                return byteBuffer2;
            }
            buffer.clear();
            while ((value = stream.read()) != -1) {
                if (buffer.remaining() < 1) {
                    ByteBuffer newBuf = BufferUtils.createByteBuffer(buffer.capacity() * 2);
                    newBuf.put(buffer);
                    buffer = newBuf;
                }
                buffer.put((byte)value);
            }
            IntBuffer x = BufferUtils.createIntBuffer(1);
            IntBuffer y = BufferUtils.createIntBuffer(1);
            IntBuffer comp = BufferUtils.createIntBuffer(1);
            ByteBuffer byteBuffer = Objects.requireNonNull(STBImage.stbi_load_from_memory((ByteBuffer)buffer.flip(), x, y, comp, 4), STBImage::stbi_failure_reason);
            return byteBuffer;
        }
        catch (Exception e) {
            LOGGER.error("Couldn't open icon image...", e);
            return null;
        }
    }

    public static class MonitorInfo {
        public final long handle;
        public final int posX;
        public final int posY;
        public final int widthScreenCoords;
        public final int heightScreenCoords;
        public final int refreshRate;

        public MonitorInfo(long monitor) {
            this.handle = monitor;
            GLFWVidMode vidmode = GLFW.glfwGetVideoMode(monitor);
            int[] x = new int[1];
            int[] y = new int[1];
            GLFW.glfwGetMonitorPos(monitor, x, y);
            this.posX = x[0];
            this.posY = y[0];
            this.widthScreenCoords = vidmode.width();
            this.heightScreenCoords = vidmode.height();
            this.refreshRate = vidmode.refreshRate();
        }
    }
}

