/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util.helper;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;

public abstract class Colors {
    private static Minecraft mc = Minecraft.getMinecraft();
    public static final net.minecraft.core.util.helper.Color[] allChatColors = new net.minecraft.core.util.helper.Color[16];
    public static final net.minecraft.core.util.helper.Color[] allPlankColors = new net.minecraft.core.util.helper.Color[16];
    public static final net.minecraft.core.util.helper.Color[] allLampColors = new net.minecraft.core.util.helper.Color[16];
    public static final net.minecraft.core.util.helper.Color[] allFlagColors = new net.minecraft.core.util.helper.Color[16];
    public static final net.minecraft.core.util.helper.Color[] allSignColors = new net.minecraft.core.util.helper.Color[16];
    public static final net.minecraft.core.util.helper.Color[] allRedstoneColors = new net.minecraft.core.util.helper.Color[16];
    public static final net.minecraft.core.util.helper.Color[] allPortalColors = new net.minecraft.core.util.helper.Color[16];

    public static void loadDummyColors() {
        net.minecraft.core.util.helper.Color white = new net.minecraft.core.util.helper.Color().setRGB(255, 255, 255);
        Arrays.fill(allChatColors, white);
        Arrays.fill(allPlankColors, white);
        Arrays.fill(allLampColors, white);
        Arrays.fill(allFlagColors, white);
        Arrays.fill(allSignColors, white);
        Arrays.fill(allRedstoneColors, white);
        Arrays.fill(allPortalColors, white);
    }

    public static void loadColors() {
        Colors.fillColorArray("/assets/minecraft/textures/misc/colors_chat.png", allChatColors);
        Colors.fillColorArray("/assets/minecraft/textures/misc/colors_planks.png", allPlankColors);
        Colors.fillColorArray("/assets/minecraft/textures/misc/colors_signs.png", allSignColors);
        Colors.fillColorArray("/assets/minecraft/textures/misc/colors_lamps.png", allLampColors);
        Colors.fillColorArray("/assets/minecraft/textures/misc/colors_flag.png", allFlagColors);
        Colors.fillColorArray("/assets/minecraft/textures/misc/colors_redstone.png", allRedstoneColors);
        Colors.fillColorArray("/assets/minecraft/textures/misc/colors_portal.png", allPortalColors);
    }

    public static void fillColorArray(String path, net.minecraft.core.util.helper.Color[] colors) {
        try {
            InputStream stream = Colors.mc.texturePackList.getResourceAsStream(path);
            BufferedImage image = ImageIO.read(stream);
            stream.close();
            Colors.fillColorArray(colors, image);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load colors from image: " + path, e);
        }
    }

    public static net.minecraft.core.util.helper.Color[] fillColorArray(net.minecraft.core.util.helper.Color[] colors, BufferedImage image) {
        if (image.getWidth() != colors.length || image.getHeight() != 1) {
            throw new RuntimeException("Invalid Color image size! Must be " + colors.length + " x 1");
        }
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = new net.minecraft.core.util.helper.Color().setARGB(image.getRGB(i, 0));
        }
        return colors;
    }

    public static BufferedImage createColorImage(net.minecraft.core.util.helper.Color[] colors, int scale) {
        int w = colors.length * scale;
        int h = scale;
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics g = image.getGraphics();
        for (int i = 0; i < colors.length; ++i) {
            net.minecraft.core.util.helper.Color c = colors[i];
            g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()));
            g.fillRect(i * scale, 0, scale, scale);
        }
        return image;
    }
}

