/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.lang;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.lang.WorldNameGenerator;
import org.slf4j.Logger;

public class Language {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected List<String> reportedMissingTranslations = new ArrayList<String>();
    protected final Properties entries;
    private final String id;
    private final String name;
    private final String region;
    private final List<String> credits;
    protected List<String> tips = null;
    protected WorldNameGenerator worldNameGenerator = null;

    Language(String id, String name, String region, List<String> credits, ZipFile zipFile) {
        this.id = id;
        this.name = name;
        this.region = region;
        this.credits = credits;
        this.entries = new Properties();
        if (zipFile != null) {
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                BufferedReader bufferedReader;
                InputStreamReader reader;
                InputStream in;
                ZipEntry entry = zipEntries.nextElement();
                if (entry.getName().endsWith(".lang")) {
                    try {
                        in = zipFile.getInputStream(entry);
                        try {
                            reader = new InputStreamReader(in, StandardCharsets.UTF_8);
                            try {
                                this.entries.load(reader);
                            }
                            finally {
                                reader.close();
                            }
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to load lang file '{}' in '{}'", entry, name, e);
                    }
                    continue;
                }
                if (this.tips == null && entry.getName().endsWith("tips.txt")) {
                    try {
                        in = zipFile.getInputStream(entry);
                        try {
                            reader = new InputStreamReader(in, StandardCharsets.UTF_8);
                            try {
                                bufferedReader = new BufferedReader(reader);
                                try {
                                    String st;
                                    this.tips = new ArrayList<String>();
                                    while ((st = bufferedReader.readLine()) != null) {
                                        this.tips.add(st);
                                    }
                                }
                                finally {
                                    bufferedReader.close();
                                }
                            }
                            finally {
                                reader.close();
                            }
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to load 'tips.txt' file in '{}'", (Object)this.getName(), (Object)e);
                    }
                    continue;
                }
                if (!entry.getName().endsWith("worldnames.txt")) continue;
                try {
                    in = zipFile.getInputStream(entry);
                    try {
                        reader = new InputStreamReader(in, StandardCharsets.UTF_8);
                        try {
                            bufferedReader = new BufferedReader(reader);
                            try {
                                this.worldNameGenerator = new WorldNameGenerator(bufferedReader.lines().collect(Collectors.toList()));
                            }
                            finally {
                                bufferedReader.close();
                            }
                        }
                        finally {
                            reader.close();
                        }
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Failed to load 'worldnames.txt' file in '{}'", (Object)this.getName(), (Object)e);
                }
            }
            try {
                zipFile.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    Language(String id, String name, String region, List<String> credits, File directory) {
        this.id = id;
        this.name = name;
        this.region = region;
        this.credits = credits;
        this.entries = new Properties();
        if (directory != null) {
            this.loadFromDirectory(directory);
        }
    }

    private void loadFromDirectory(File directory) {
        assert (directory.isDirectory()) : "Directory file must actually be a directory!";
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            BufferedReader bufferedReader;
            InputStream stream;
            InputStreamReader reader;
            File currentFile = files[i];
            if (currentFile.isDirectory()) {
                this.loadFromDirectory(currentFile);
                continue;
            }
            if (currentFile.getPath().endsWith(".lang")) {
                try (InputStream in = Files.newInputStream(currentFile.toPath(), new OpenOption[0]);){
                    reader = new InputStreamReader(in, StandardCharsets.UTF_8);
                    try {
                        this.entries.load(reader);
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Failed to load lang file '{}' in '{}'", currentFile.getName(), this.name, e);
                }
                continue;
            }
            if (this.tips == null && currentFile.getPath().endsWith("tips.txt")) {
                try {
                    stream = Files.newInputStream(currentFile.toPath(), new OpenOption[0]);
                    try {
                        reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                        try {
                            bufferedReader = new BufferedReader(reader);
                            try {
                                String st;
                                this.tips = new ArrayList<String>();
                                while ((st = bufferedReader.readLine()) != null) {
                                    this.tips.add(st);
                                }
                            }
                            finally {
                                bufferedReader.close();
                            }
                        }
                        finally {
                            reader.close();
                        }
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Failed to load 'tips.txt' file in '{}'", (Object)this.getName(), (Object)e);
                }
                continue;
            }
            if (!currentFile.getPath().endsWith("worldnames.txt")) continue;
            try {
                stream = Files.newInputStream(currentFile.toPath(), new OpenOption[0]);
                try {
                    reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                    try {
                        bufferedReader = new BufferedReader(reader);
                        try {
                            this.worldNameGenerator = new WorldNameGenerator(bufferedReader.lines().collect(Collectors.toList()));
                            continue;
                        }
                        finally {
                            bufferedReader.close();
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to load 'worldnames.txt' file in '{}'", (Object)this.getName(), (Object)e);
            }
        }
    }

    public String translateKey(String key) {
        if (key == null) {
            return null;
        }
        String ret = this.entries.getProperty(key);
        if (ret == null) {
            if (!this.reportedMissingTranslations.contains(key)) {
                LOGGER.error("Missing translation: {}\n at {}", (Object)key, (Object)Thread.currentThread().getStackTrace()[2]);
                this.reportedMissingTranslations.add(key);
            }
            return Default.INSTANCE.translateKey(key);
        }
        return ret;
    }

    public String translateKeyAndFormat(String formatKey, Object ... args) {
        String format = this.entries.getProperty(formatKey, formatKey);
        if (formatKey.equals(format)) {
            format = Default.INSTANCE.entries.getProperty(formatKey, formatKey);
        }
        return String.format(format, args);
    }

    public List<String> getTips() {
        if (this.tips == null) {
            return Default.INSTANCE.getTips();
        }
        return this.tips;
    }

    public String getRandomWorldName() {
        if (this.worldNameGenerator == null) {
            return Default.INSTANCE.getRandomWorldName();
        }
        return this.worldNameGenerator.getRandomWorldName();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getCredits() {
        return this.credits;
    }

    public String getRegion() {
        return this.region;
    }

    public int keySize() {
        return this.entries.size();
    }

    void onReload() {
    }

    public boolean isDefault() {
        return false;
    }

    public static final class Default
    extends Language {
        public static final Default INSTANCE = new Default();

        private Default() {
            super("en_US", "English", "US", Arrays.asList("Mojang", "jonkadelic", "skydeckagogo"), (ZipFile)null);
            this.entries.clear();
            for (String path : I18n.getFilesInDirectory("/lang/en_US/")) {
                BufferedReader bufferedReader;
                InputStreamReader reader;
                InputStream stream;
                if (path.endsWith(".lang")) {
                    try {
                        stream = I18n.getResourceAsStream(path);
                        try {
                            reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                            try {
                                this.entries.load(reader);
                            }
                            finally {
                                reader.close();
                            }
                        }
                        finally {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to load lang file '{}' in '{}'", path, this.getName(), e);
                    }
                    continue;
                }
                if (this.tips == null && path.endsWith("/tips.txt")) {
                    try {
                        stream = I18n.getResourceAsStream(path);
                        try {
                            reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                            try {
                                bufferedReader = new BufferedReader(reader);
                                try {
                                    String st;
                                    this.tips = new ArrayList();
                                    while ((st = bufferedReader.readLine()) != null) {
                                        this.tips.add(st);
                                    }
                                }
                                finally {
                                    bufferedReader.close();
                                }
                            }
                            finally {
                                reader.close();
                            }
                        }
                        finally {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to load 'tips.txt' file in '{}'", (Object)this.getName(), (Object)e);
                    }
                    continue;
                }
                if (!path.endsWith("/worldnames.txt")) continue;
                try {
                    stream = I18n.getResourceAsStream(path);
                    try {
                        reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                        try {
                            bufferedReader = new BufferedReader(reader);
                            try {
                                this.worldNameGenerator = new WorldNameGenerator(bufferedReader.lines().collect(Collectors.toList()));
                            }
                            finally {
                                bufferedReader.close();
                            }
                        }
                        finally {
                            reader.close();
                        }
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Failed to load 'worldnames.txt' file in '{}'", (Object)this.getName(), (Object)e);
                }
            }
        }

        @Override
        public String translateKey(String key) {
            if (key == null) {
                return null;
            }
            String ret = this.entries.getProperty(key);
            if (ret == null) {
                if (!this.reportedMissingTranslations.contains(key)) {
                    this.reportedMissingTranslations.add(key);
                    LOGGER.error("Missing translation in default language: {}\n at {}", (Object)key, (Object)Thread.currentThread().getStackTrace()[3]);
                }
                return key;
            }
            return ret;
        }

        @Override
        public boolean isDefault() {
            return true;
        }
    }
}

