/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.util;

import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class ConcatIterable<T>
implements Iterable<T> {
    private final Iterable<T> first;
    private final Iterable<T> second;

    public ConcatIterable(Iterable<T> first, Iterable<T> second) {
        this.first = first;
        this.second = second;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Iterator<T> firstIterator;
            private final Iterator<T> secondIterator;
            private boolean firstIteratorActive;
            {
                this.firstIterator = ConcatIterable.this.first.iterator();
                this.secondIterator = ConcatIterable.this.second.iterator();
                this.firstIteratorActive = true;
            }

            @Override
            public boolean hasNext() {
                if (this.firstIteratorActive) {
                    if (this.firstIterator.hasNext()) {
                        return true;
                    }
                    this.firstIteratorActive = false;
                }
                return this.secondIterator.hasNext();
            }

            @Override
            public T next() {
                if (this.firstIteratorActive) {
                    if (this.firstIterator.hasNext()) {
                        return this.firstIterator.next();
                    }
                    this.firstIteratorActive = false;
                }
                return this.secondIterator.next();
            }
        };
    }
}

