/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.saveddata;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.NbtIo;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ShortTag;
import com.mojang.nbt.tags.Tag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.saveddata.SavedData;
import org.slf4j.Logger;

public class SavedDataStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final LevelStorage storage;
    private final Map<Serializable, SavedData> cache = new HashMap<Serializable, SavedData>();
    private final List<SavedData> loadedData = new ArrayList<SavedData>();
    private final Map<String, Short> idCounts = new HashMap<String, Short>();

    public SavedDataStorage(LevelStorage storage) {
        this.storage = storage;
        this.loadMetadata();
    }

    public SavedData load(Class<? extends SavedData> savedDataClass, String id) {
        SavedData savedData;
        block7: {
            savedData = this.cache.get(id);
            if (savedData != null) {
                return savedData;
            }
            if (this.storage != null) {
                try {
                    File file = this.storage.getDataFile(id);
                    if (file == null || !file.exists()) break block7;
                    try {
                        savedData = savedDataClass.getConstructor(String.class).newInstance(id);
                    }
                    catch (Exception exception1) {
                        throw new RuntimeException("Failed to instantiate " + savedDataClass.toString(), exception1);
                    }
                    InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
                    CompoundTag tag = NbtIo.readCompressed(fis);
                    fis.close();
                    savedData.load(tag.getCompound("data"));
                }
                catch (Exception e) {
                    LOGGER.error("Exception loading saved data for id '{}'!", (Object)id, (Object)e);
                }
            }
        }
        if (savedData != null) {
            this.cache.put((Serializable)((Object)id), savedData);
            this.loadedData.add(savedData);
        }
        return savedData;
    }

    public void set(String id, SavedData savedData) {
        if (savedData == null) {
            throw new RuntimeException("Can't set null data");
        }
        if (this.cache.containsKey(id)) {
            this.loadedData.remove(this.cache.remove(id));
        }
        this.cache.put((Serializable)((Object)id), savedData);
        this.loadedData.add(savedData);
    }

    public void save() {
        for (SavedData savedData : this.loadedData) {
            if (!savedData.isDirty()) continue;
            this.save(savedData);
            savedData.setDirty(false);
        }
    }

    private void save(SavedData savedData) {
        if (this.storage == null) {
            return;
        }
        try {
            File file = this.storage.getDataFile(savedData.id);
            if (file != null) {
                CompoundTag dataTag = new CompoundTag();
                savedData.save(dataTag);
                CompoundTag tag = new CompoundTag();
                tag.putCompound("data", dataTag);
                OutputStream fos = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                NbtIo.writeCompressed(tag, fos);
                fos.close();
            }
        }
        catch (Exception exception) {
            LOGGER.error("Failed to save data to '{}'!", (Object)this.storage.getDataFile(savedData.id).getPath(), (Object)exception);
        }
    }

    private void loadMetadata() {
        try {
            this.idCounts.clear();
            if (this.storage == null) {
                return;
            }
            File file = this.storage.getDataFile("idcounts");
            if (file != null && file.exists()) {
                DataInputStream dis = new DataInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
                CompoundTag tag = NbtIo.read(dis);
                dis.close();
                for (Tag<?> element : tag.getValues()) {
                    if (!(element instanceof ShortTag)) continue;
                    ShortTag shortTag = (ShortTag)element;
                    String type = shortTag.getTagName();
                    short metadata = (Short)shortTag.getValue();
                    this.idCounts.put(type, metadata);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load all savedata id counts!", e);
        }
    }

    public int getFreeMetadataFor(String type) {
        Short metadata = this.idCounts.get(type);
        metadata = metadata == null ? Short.valueOf((short)0) : Short.valueOf((short)(metadata + 1));
        this.idCounts.put(type, metadata);
        if (this.storage == null) {
            return metadata.shortValue();
        }
        try {
            File file = this.storage.getDataFile("idcounts");
            if (file != null) {
                CompoundTag tag = new CompoundTag();
                for (String dataType : this.idCounts.keySet()) {
                    short count = this.idCounts.get(dataType);
                    tag.putShort(dataType, count);
                }
                DataOutputStream dos = new DataOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
                NbtIo.write(tag, dos);
                dos.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create data file for '{}'!", (Object)this.storage.getDataFile("idcounts").getPath(), (Object)e);
        }
        return metadata.shortValue();
    }
}

