/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer.gui;

import com.mojang.logging.LogUtils;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.useless.seedviewer.collections.ChunkLocation;
import org.useless.seedviewer.gui.components.InfoPanel;
import org.useless.seedviewer.gui.components.InputPanel;
import org.useless.seedviewer.gui.components.Viewport;

public class SeedViewer
extends JFrame {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int TICKS_PER_SECOND = 10;
    public static final int BEZEL = 15;
    public final Properties launchProperties;
    private volatile boolean needsResize = true;
    public final Viewport viewport;
    public final InputPanel inputPanel;
    public final InfoPanel infoPanel;

    public SeedViewer(Properties properties) {
        ImageIO.setUseCache(false);
        LOGGER.info("Starting Seed Viewer!");
        this.launchProperties = properties;
        this.viewport = new Viewport(this);
        this.inputPanel = new InputPanel(this);
        this.infoPanel = new InfoPanel(this);
        this.initFrame();
        this.addComponents();
        Thread mainThread = new Thread(() -> {
            long tickCount = 0L;
            while (true) {
                try {
                    this.tick();
                    ++tickCount;
                }
                catch (Exception e) {
                    LOGGER.error("Exception when running tick!", e);
                }
                if (tickCount % 50L == 0L) {
                    System.gc();
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.error("Unexpected interrupt in tick thread!", e);
                    continue;
                }
                break;
            }
        });
        mainThread.setName("Main");
        mainThread.setPriority(6);
        mainThread.start();
    }

    public void initFrame() {
        LOGGER.info("Initializing Frame");
        this.setDefaultCloseOperation(2);
        this.setTitle("BTA Seed Viewer! Version: 1.1.2");
        this.setSize(960, 720);
        this.setMinimumSize(new Dimension(480, 360));
        this.setResizable(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SeedViewer.this.needsResize = true;
                SeedViewer.this.viewport.repaint();
            }
        });
        this.setLayout(null);
        this.setVisible(true);
        LOGGER.info("Loading Icons");
        try {
            ArrayList<Image> l = new ArrayList<Image>();
            l.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/assets/seedviewer/textures/icons/1024.png")));
            l.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/assets/seedviewer/textures/icons/512.png")));
            l.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/assets/seedviewer/textures/icons/256.png")));
            l.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/assets/seedviewer/textures/icons/128.png")));
            l.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/assets/seedviewer/textures/icons/64.png")));
            l.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/assets/seedviewer/textures/icons/32.png")));
            l.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/assets/seedviewer/textures/icons/16.png")));
            this.setIconImages(l);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load icons!", e);
        }
    }

    public void addComponents() {
        LOGGER.info("Creating Labels");
        this.infoPanel.setup();
        this.add(this.infoPanel);
        LOGGER.info("Creating Check boxes");
        this.inputPanel.setup();
        this.add(this.inputPanel);
        LOGGER.info("Creating Image frame");
        this.viewport.setup();
        this.add(this.viewport);
    }

    public void initComponents() {
        if (!this.needsResize) {
            return;
        }
        LOGGER.info("Initializing Components");
        this.needsResize = false;
        int screenWidth = this.getContentPane().getWidth();
        int screenHeight = this.getContentPane().getHeight();
        int inWidth = screenWidth / 4;
        if (inWidth < 100) {
            inWidth = 100;
        }
        if (inWidth > 200) {
            inWidth = 200;
        }
        int inHeight = screenHeight - 30;
        this.inputPanel.onResize(new Rectangle(0, 15, inWidth, inHeight / 2));
        this.inputPanel.setVisible(true);
        inWidth = screenWidth / 4;
        if (inWidth < 100) {
            inWidth = 100;
        }
        if (inWidth > 200) {
            inWidth = 200;
        }
        inHeight = screenHeight - 30;
        this.infoPanel.onResize(new Rectangle(0, this.inputPanel.getY() + this.inputPanel.getHeight() - 1, inWidth, inHeight / 2));
        this.infoPanel.setVisible(true);
        int viewWidth = screenWidth - 30 - (this.inputPanel.isVisible() ? this.inputPanel.getWidth() : 0);
        int viewX = 15 + (this.inputPanel.isVisible() ? this.inputPanel.getWidth() : 0);
        this.viewport.onResize(new Rectangle(viewX, 15, viewWidth, screenHeight - 30));
    }

    public void queueResize() {
        this.needsResize = true;
    }

    public void forceResize() {
        this.queueResize();
        this.initComponents();
    }

    public synchronized void tick() {
        this.initComponents();
        this.viewport.tick();
    }

    public static boolean isSlimeChunk(long worldSeed, @NotNull ChunkLocation location) {
        long slimeXOR = 987234911L;
        Random slimerandom = new Random(worldSeed + (long)(location.x * location.x) * 4987142L + (long)location.x * 5947611L + (long)(location.z * location.z) * 4392871L + (long)location.z * 389711L ^ slimeXOR);
        return slimerandom.nextInt(10) == 0;
    }
}

