/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.gui;

import b100.minimap.gui.GuiContainer;
import b100.minimap.gui.GuiElement;
import b100.minimap.gui.GuiScreen;
import java.util.ArrayList;
import java.util.List;

public class GuiNavigationContainer
extends GuiContainer {
    public GuiScreen screen;
    public GuiContainer parent;
    public Position position;
    public List<GuiElement> navigationElements = new ArrayList<GuiElement>();
    public int spacing = 8;

    public GuiNavigationContainer(GuiScreen screen, GuiContainer parent, Position position) {
        this.screen = screen;
        this.parent = parent;
        this.position = position;
    }

    @Override
    public void onResize() {
        int buttonWidth = 50;
        int buttonHeight = 0;
        for (int i = 0; i < this.navigationElements.size(); ++i) {
            buttonWidth = Math.max(buttonWidth, this.navigationElements.get((int)i).width);
            buttonHeight = Math.max(buttonHeight, this.navigationElements.get((int)i).height);
        }
        int width = this.navigationElements.size() * buttonWidth + (this.navigationElements.size() - 1) * this.spacing;
        int x0 = (this.screen.width - width) / 2;
        int y0 = this.spacing;
        if (this.position == Position.TOP) {
            y0 = this.parent.posY - this.spacing - buttonHeight;
        }
        if (this.position == Position.BOTTOM) {
            y0 = this.parent.posY + this.parent.height + this.spacing;
        }
        for (int i = 0; i < this.navigationElements.size(); ++i) {
            this.navigationElements.get(i).setPositionAndSize(x0 + (this.spacing + buttonWidth) * i, y0, buttonWidth, buttonHeight);
        }
    }

    @Override
    public <E extends GuiElement> E add(E element) {
        this.navigationElements.add(element);
        return super.add(element);
    }

    public static enum Position {
        TOP,
        BOTTOM;

    }
}

