/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.gui;

import b100.minimap.gui.GuiContainer;
import b100.minimap.gui.GuiContainerBox;
import b100.minimap.gui.GuiElement;
import b100.minimap.gui.GuiScreen;
import java.util.ArrayList;
import java.util.List;

public class GuiOptionsContainer
extends GuiContainerBox {
    public GuiScreen screen;
    private List<Line> lines = new ArrayList<Line>();
    public int buttonWidth = 50;
    public int buttonHeight = 10;

    public GuiOptionsContainer(GuiScreen screen) {
        this.screen = screen;
    }

    @Override
    public void onResize() {
        this.resizeContainer();
        this.resizeNavigation();
    }

    private void resizeContainer() {
        int paddingOuter = 2;
        boolean paddingInner = true;
        int maxStringWidth = 0;
        for (int i = 0; i < this.lines.size(); ++i) {
            maxStringWidth = Math.max(maxStringWidth, this.utils.getStringWidth(this.lines.get(i).text));
        }
        int w = (maxStringWidth += 8) + this.buttonWidth + 4;
        int h = this.lines.size() * this.buttonHeight + (this.lines.size() - 1) * 1 + 4;
        int x = (this.screen.width - w) / 2;
        int y = (this.screen.height - h) / 2;
        this.setPositionAndSize(x, y, w, h);
        for (int i = 0; i < this.lines.size(); ++i) {
            this.lines.get(i).setPosition(x + 2, y + 2 + i * (this.buttonHeight + 1));
            this.lines.get(i).setSize(w - 4, this.buttonHeight);
            this.lines.get(i).setElementPosition(this.buttonWidth);
        }
    }

    private void resizeNavigation() {
    }

    public void add(String text, GuiElement element) {
        Line line = new Line(text, element);
        this.add(line);
        this.lines.add(line);
    }

    private class Line
    extends GuiContainer {
        private String text;
        private GuiElement element;

        public Line(String text, GuiElement element) {
            this.text = text;
            this.element = element;
            this.add(element);
        }

        @Override
        public void draw(float partialTicks) {
            super.draw(partialTicks);
            GuiElement element = GuiOptionsContainer.this.screen.getClickElementAt(GuiOptionsContainer.this.screen.cursorX, GuiOptionsContainer.this.screen.cursorY);
            boolean mouseOver = element == this || element == this.element;
            this.utils.drawString(this.text, this.posX, this.posY + this.height / 2 - 4, mouseOver ? 0xFFFFFF : 0xCCCCCC);
        }

        public void setElementPosition(int elementWidth) {
            this.element.setPosition(this.posX + this.width - elementWidth, this.posY);
            this.element.setSize(elementWidth, this.height);
        }
    }
}

