/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.gui;

import b100.minimap.gui.CancelEventException;
import b100.minimap.gui.GuiContainer;
import org.lwjgl.input.Keyboard;

public abstract class GuiScreen
extends GuiContainer {
    private GuiScreen parentScreen;
    public int width;
    public int height;
    public int cursorX;
    public int cursorY;
    private boolean initialized = false;

    public GuiScreen(GuiScreen parentScreen) {
        this.parentScreen = parentScreen;
    }

    public final void init() {
        this.elements.clear();
        this.onInit();
        if (this.initialized) {
            this.onResize();
        }
        this.initialized = true;
    }

    @Override
    public void keyEvent(int key, char c, boolean pressed, boolean repeat, int mouseX, int mouseY) {
        super.keyEvent(key, c, pressed, repeat, mouseX, mouseY);
        if (pressed) {
            if (key == Keyboard.KEY_ESCAPE) {
                this.close();
                throw new CancelEventException();
            }
            if (key == Keyboard.KEY_BACK) {
                this.back();
                throw new CancelEventException();
            }
            if (key == Keyboard.KEY_F5) {
                this.onResize();
            }
        }
    }

    public abstract void onInit();

    public boolean isInitialized() {
        return this.initialized;
    }

    public void back() {
        this.utils.displayGui(this.parentScreen);
    }

    public void close() {
        this.utils.displayGui(null);
    }

    public void onGuiOpened() {
    }

    public void onGuiClosed() {
    }
}

