/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.gui;

import b100.minimap.gui.CancelEventException;
import b100.minimap.gui.GuiButton;
import b100.minimap.gui.GuiContainerBox;
import b100.minimap.gui.GuiElement;
import b100.minimap.gui.GuiScreen;
import b100.minimap.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class GuiScrollableContainer
extends GuiContainerBox {
    public GuiScreen screen;
    public int elementsPerPage;
    public int scrollLevel;
    public int elementWidth = 120;
    public int elementHeight = 10;
    public int scrollButtonSize = 10;
    public List<GuiElement> nonScrollableElements = new ArrayList<GuiElement>();
    public List<GuiElement> scrollableElements = new ArrayList<GuiElement>();
    public GuiButton buttonScrollUp;
    public GuiButton buttonScrollDown;
    private boolean needsUpdate = false;

    public GuiScrollableContainer(GuiScreen screen, int elementCount) {
        this.screen = screen;
        this.elementsPerPage = elementCount;
        this.buttonScrollUp = new GuiButton(screen, 0).addActionListener(e -> this.scroll(-1));
        this.buttonScrollDown = new GuiButton(screen, 1).addActionListener(e -> this.scroll(1));
        this.add(this.buttonScrollUp);
        this.add(this.buttonScrollDown);
    }

    @Override
    public void draw(float partialTicks) {
        if (this.needsUpdate) {
            this.update();
        }
        super.draw(partialTicks);
    }

    public void update() {
        this.needsUpdate = false;
        int maxScrollLevel = Math.max(0, this.scrollableElements.size() - this.elementsPerPage);
        this.scrollLevel = Utils.clamp(this.scrollLevel, 0, maxScrollLevel);
        this.buttonScrollUp.clickable = this.scrollLevel > 0;
        this.buttonScrollDown.clickable = this.scrollLevel < maxScrollLevel;
        this.elements.clear();
        this.elements.addAll(this.nonScrollableElements);
        int paddingOuter = 2;
        boolean paddingInner = true;
        int w = this.elementWidth + 1 + this.scrollButtonSize + 4;
        int h = this.elementsPerPage * this.elementHeight + (this.elementsPerPage - 1) * 1 + 4;
        int x = (this.screen.width - w) / 2;
        int y = (this.screen.height - h) / 2;
        this.setPositionAndSize(x, y, w, h);
        for (int i = 0; i < this.scrollableElements.size(); ++i) {
            GuiElement element = this.scrollableElements.get(i);
            int listPosition = i - this.scrollLevel;
            if (listPosition >= 0 && listPosition < this.elementsPerPage) {
                int x0 = x + 2;
                int y0 = y + 2 + (this.elementHeight + 1) * listPosition;
                element.setPosition(x0, y0);
                this.elements.add(element);
            } else {
                element.setPosition(0, 0);
            }
            element.setSize(this.elementWidth, this.elementHeight);
        }
        this.buttonScrollUp.setSize(this.scrollButtonSize, this.scrollButtonSize);
        this.buttonScrollDown.setSize(this.scrollButtonSize, this.scrollButtonSize);
        this.buttonScrollUp.setPosition(x + 2 + this.elementWidth + 1, y + 2);
        this.buttonScrollDown.setPosition(x + 2 + this.elementWidth + 1, y + h - 2 - this.scrollButtonSize);
    }

    @Override
    public void onResize() {
        this.update();
    }

    @Override
    public void scrollEvent(int dir, int mouseX, int mouseY) {
        if ((dir = Utils.clamp(dir, -1, 1)) < 0) {
            this.scroll(1);
            throw new CancelEventException();
        }
        if (dir > 0 && this.scrollLevel > 0) {
            this.scroll(-1);
            throw new CancelEventException();
        }
        super.scrollEvent(dir, mouseX, mouseY);
    }

    public void scroll(int dir) {
        this.scrollLevel += dir;
        this.needsUpdate = true;
    }

    public void setScrollLevel(int dir) {
        this.scrollLevel = dir;
        this.needsUpdate = true;
    }

    @Override
    public <E extends GuiElement> E add(E element) {
        this.nonScrollableElements.add(element);
        this.needsUpdate = true;
        return element;
    }

    public <E extends GuiElement> E addScrollable(E element) {
        this.scrollableElements.add(element);
        this.needsUpdate = true;
        return element;
    }
}

