/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.gui;

import b100.minimap.gui.CancelEventException;
import b100.minimap.gui.GuiLabel;
import b100.minimap.gui.TextComponentListener;
import b100.minimap.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiTextComponent
extends GuiLabel {
    public int cursorPosition;
    public int textSelection = -1;
    public boolean editable = true;
    public boolean focused = false;
    private long blinkTime = 0L;
    private long blinkDuration = 600L;
    private List<TextComponentListener> textComponentListeners = new ArrayList<TextComponentListener>();

    public GuiTextComponent(String string) {
        super(string);
    }

    public GuiTextComponent(String string, int posX, int posy) {
        super(string, posX, posy);
    }

    @Override
    public void draw(float partialTicks) {
        this.cursorPosition = Utils.clamp(this.cursorPosition, 0, this.text.length());
        this.textSelection = Utils.clamp(this.textSelection, -1, this.text.length());
        GL11.glEnable((int)3553);
        int textColor = this.getTextColor() | 0xFF000000;
        if (!this.focused || !this.editable) {
            this.textSelection = -1;
        }
        if (this.isTextSelected()) {
            int selectionStart = this.getSelectionStart();
            int selectionEnd = this.getSelectionEnd();
            String str0 = this.text.substring(0, selectionStart);
            String str1 = this.text.substring(selectionStart, selectionEnd);
            String str2 = this.text.substring(selectionEnd);
            int offset0 = this.utils.getStringWidth(str0);
            int offset1 = this.utils.getStringWidth(str1);
            this.utils.drawString(str0, this.posX, this.posY, textColor);
            this.utils.drawString(str1, this.posX + offset0, this.posY, 0xFFFF00);
            this.utils.drawString(str2, this.posX + offset0 + offset1, this.posY, textColor);
            GL11.glDisable((int)3553);
            GL11.glBlendFunc((int)775, (int)769);
            this.utils.drawRectangle(this.posX + offset0, this.posY - 1, offset1, 10, -1);
            GL11.glEnable((int)3553);
            GL11.glBlendFunc((int)770, (int)771);
        } else {
            this.utils.drawString(this.text, this.posX, this.posY, textColor);
        }
        if (this.focused && this.editable) {
            boolean blink;
            boolean bl = blink = (System.currentTimeMillis() - this.blinkTime) % this.blinkDuration < this.blinkDuration / 2L;
            if (blink) {
                int offset;
                if (this.cursorPosition == this.text.length()) {
                    offset = this.utils.getStringWidth(this.text);
                    this.utils.drawString("_", this.posX + offset, this.posY, textColor);
                } else {
                    offset = this.utils.getStringWidth(this.text.substring(0, this.cursorPosition));
                    GL11.glDisable((int)3553);
                    this.utils.drawRectangle(this.posX + offset, this.posY - 1, 1, 10, textColor);
                }
            }
        }
    }

    public void keyEvent(int key, char c, boolean pressed) {
        boolean shift;
        if (!(this.editable && this.focused && pressed)) {
            return;
        }
        boolean control = Keyboard.isKeyDown((int)Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown((int)Keyboard.KEY_RCONTROL);
        boolean bl = shift = Keyboard.isKeyDown((int)Keyboard.KEY_LSHIFT) || Keyboard.isKeyDown((int)Keyboard.KEY_RSHIFT);
        if (!this.isTextSelected() && shift) {
            this.textSelection = this.cursorPosition;
        }
        if (control) {
            if (key == Keyboard.KEY_A) {
                this.textSelection = 0;
                this.cursorPosition = this.text.length();
                this.onUpdate();
                throw new CancelEventException();
            }
            if (key == Keyboard.KEY_C) {
                String stringToCopy = this.text;
                if (this.isTextSelected()) {
                    stringToCopy = this.text.substring(this.getSelectionStart(), this.getSelectionEnd());
                }
                Utils.copyStringToClipboard(stringToCopy);
                throw new CancelEventException();
            }
            if (key == Keyboard.KEY_V) {
                String clipboardString = Utils.getClipboardString();
                if (clipboardString != null && clipboardString.length() > 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < clipboardString.length(); ++i) {
                        char c1 = clipboardString.charAt(i);
                        if (!this.isCharacterAllowed(c1)) continue;
                        stringBuilder.append(c1);
                    }
                    clipboardString = stringBuilder.toString();
                    if (clipboardString.length() > 0) {
                        this.text = this.isTextSelected() ? this.text.substring(0, this.getSelectionStart()) + clipboardString + this.text.substring(this.getSelectionEnd()) : this.text.substring(0, this.cursorPosition) + clipboardString + this.text.substring(this.cursorPosition);
                        this.onUpdate();
                    }
                }
                throw new CancelEventException();
            }
        }
        if (key == Keyboard.KEY_BACK) {
            if (this.isTextSelected()) {
                int i = this.getSelectionStart();
                this.text = this.text.substring(0, this.getSelectionStart()) + this.text.substring(this.getSelectionEnd());
                this.cursorPosition = i;
                this.textSelection = -1;
            } else if (this.cursorPosition > 0) {
                if (control) {
                    int i = this.getNextWordStartPosition(this.cursorPosition, -1);
                    this.text = this.text.substring(0, i) + this.text.substring(this.cursorPosition);
                    this.cursorPosition = i;
                } else {
                    this.text = this.text.substring(0, this.cursorPosition - 1) + this.text.substring(this.cursorPosition);
                }
                --this.cursorPosition;
                this.onUpdate();
            }
            throw new CancelEventException();
        }
        if (key == Keyboard.KEY_DELETE) {
            if (this.isTextSelected()) {
                int i = this.getSelectionStart();
                this.text = this.text.substring(0, this.getSelectionStart()) + this.text.substring(this.getSelectionEnd());
                this.cursorPosition = i;
                this.textSelection = -1;
            } else if (this.cursorPosition < this.text.length()) {
                if (control) {
                    int i = this.getNextWordStartPosition(this.cursorPosition, 1);
                    this.text = this.text.substring(0, this.cursorPosition) + this.text.substring(i);
                } else {
                    this.text = this.text.substring(0, this.cursorPosition) + this.text.substring(this.cursorPosition + 1);
                    this.onUpdate();
                }
            }
            throw new CancelEventException();
        }
        if (key == Keyboard.KEY_HOME) {
            this.cursorPosition = 0;
            this.onUpdate();
            if (!shift) {
                this.textSelection = -1;
            }
            throw new CancelEventException();
        }
        if (key == Keyboard.KEY_END) {
            this.cursorPosition = this.text.length();
            this.onUpdate();
            if (!shift) {
                this.textSelection = -1;
            }
            throw new CancelEventException();
        }
        if (key == Keyboard.KEY_LEFT) {
            this.cursorPosition = control ? this.getNextWordStartPosition(this.cursorPosition, -1) : --this.cursorPosition;
            if (!shift) {
                this.textSelection = -1;
            }
            this.onUpdate();
            throw new CancelEventException();
        }
        if (key == Keyboard.KEY_RIGHT) {
            this.cursorPosition = control ? this.getNextWordStartPosition(this.cursorPosition, 1) : ++this.cursorPosition;
            if (!shift) {
                this.textSelection = -1;
            }
            this.onUpdate();
            throw new CancelEventException();
        }
        if (this.isCharacterAllowed(c)) {
            if (this.isTextSelected() && this.textSelection != this.cursorPosition) {
                int i = this.getSelectionStart();
                this.text = this.text.substring(0, this.getSelectionStart()) + c + this.text.substring(this.getSelectionEnd());
                this.cursorPosition = i + 1;
                this.textSelection = -1;
            } else {
                this.text = this.text.substring(0, this.cursorPosition) + c + this.text.substring(this.cursorPosition);
                ++this.cursorPosition;
                this.textSelection = -1;
            }
            this.onUpdate();
            throw new CancelEventException();
        }
    }

    public void scrollEvent(int direction) {
    }

    public int getNextWordStartPosition(int start, int dir) {
        if ((dir = Utils.clamp(dir, -1, 1)) == 0) {
            throw new IllegalArgumentException(String.valueOf(dir));
        }
        for (int i = start + dir; i >= 0 && i <= this.text.length(); i += dir) {
            if (i == 0 || i >= this.text.length()) {
                return i;
            }
            if (this.text.charAt(i) == ' ' || this.text.charAt(i - 1) != ' ') continue;
            return i;
        }
        return dir > 0 ? this.text.length() : 0;
    }

    public void onUpdate() {
        this.cursorPosition = Utils.clamp(this.cursorPosition, 0, this.text.length());
        this.textSelection = Utils.clamp(this.textSelection, -1, this.text.length());
        if (this.cursorPosition == this.textSelection) {
            this.textSelection = -1;
        }
        try {
            for (int i = 0; i < this.textComponentListeners.size(); ++i) {
                this.textComponentListeners.get(i).onTextComponentChanged(this);
            }
        }
        catch (CancelEventException cancelEventException) {
            // empty catch block
        }
    }

    @Override
    public void setText(String string) {
        this.text = string;
        this.cursorPosition = string.length();
        this.textSelection = -1;
        this.onUpdate();
    }

    public boolean isCharacterAllowed(char c) {
        return this.mc.isCharacterAllowed(c);
    }

    public void setFocused(boolean focused) {
        if (focused) {
            if (!this.focused) {
                this.blinkTime = System.currentTimeMillis();
                this.cursorPosition = this.text.length();
            }
            this.focused = true;
        } else {
            this.focused = false;
        }
    }

    public boolean isTextSelected() {
        return this.textSelection != -1;
    }

    public int getSelectionStart() {
        if (!this.isTextSelected()) {
            return -1;
        }
        return Math.min(this.cursorPosition, this.textSelection);
    }

    public int getSelectionEnd() {
        if (!this.isTextSelected()) {
            return -1;
        }
        return Math.max(this.cursorPosition, this.textSelection);
    }

    public GuiTextComponent addTextComponentListener(TextComponentListener textComponentListener) {
        this.textComponentListeners.add(textComponentListener);
        return this;
    }

    public GuiTextComponent removeTextComponentListener(TextComponentListener textComponentListener) {
        this.textComponentListeners.remove(textComponentListener);
        return this;
    }
}

