/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.gui;

import b100.minimap.gui.CancelEventException;
import b100.minimap.gui.Colors;
import b100.minimap.gui.GuiTextComponent;
import b100.minimap.utils.Utils;

public class GuiTextComponentInteger
extends GuiTextComponent {
    public Integer min;
    public Integer max;
    private int value;
    private boolean isValid = true;

    public GuiTextComponentInteger(int value) {
        super(String.valueOf(value));
        this.value = value;
    }

    public GuiTextComponentInteger(int value, Integer min, Integer max) {
        super(String.valueOf(value));
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean isCharacterAllowed(char c) {
        return super.isCharacterAllowed(c) && "0123456789-".indexOf(c) != -1;
    }

    public void setValue(int value) {
        this.setText(String.valueOf(this.clamp(value)));
    }

    public int getValue() {
        return this.value;
    }

    public int clamp(int val) {
        if (this.min != null && val < this.min) {
            return this.min;
        }
        if (this.max != null && val > this.max) {
            return this.max;
        }
        return val;
    }

    @Override
    public void onUpdate() {
        try {
            int value = Integer.parseInt(this.text);
            this.isValid = true;
            int clampedValue = this.clamp(value);
            if (value != clampedValue) {
                this.setValue(clampedValue);
            } else {
                this.value = value;
            }
        }
        catch (NumberFormatException e) {
            this.isValid = false;
        }
        super.onUpdate();
    }

    @Override
    public void scrollEvent(int direction) {
        super.scrollEvent(direction);
        if (this.focused) {
            int newValue = this.clamp(this.value + Utils.clamp(direction, -1, 1));
            if (newValue != this.value) {
                this.setValue(newValue);
            }
            throw new CancelEventException();
        }
    }

    @Override
    public int getTextColor() {
        return this.isValid ? super.getTextColor() : Colors.textInvalid;
    }
}

