/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.gui.waypoint;

import b100.minimap.Minimap;
import b100.minimap.gui.Colors;
import b100.minimap.gui.GuiButton;
import b100.minimap.gui.GuiContextMenu;
import b100.minimap.gui.waypoint.GuiEditWaypoint;
import b100.minimap.gui.waypoint.GuiWaypoints;
import b100.minimap.waypoint.Waypoint;
import org.lwjgl.opengl.GL11;

public class GuiWaypointButton
extends GuiButton {
    public GuiWaypoints guiWaypoints;
    public Waypoint waypoint;

    public GuiWaypointButton(GuiWaypoints screen, Waypoint waypoint) {
        super(screen);
        this.guiWaypoints = screen;
        this.waypoint = waypoint;
    }

    @Override
    public void draw(float partialTicks) {
        super.draw(partialTicks);
        int colorSquareSize = this.height;
        GL11.glDisable((int)3553);
        this.utils.drawRectangle(this.posX + this.width - colorSquareSize, this.posY, colorSquareSize, colorSquareSize, this.waypoint.color | 0xFF000000);
        GL11.glEnable((int)3553);
        this.utils.drawString(this.waypoint.name, this.posX + 2, this.posY + this.height / 2 - 4, this.waypoint.visible ? Colors.buttonText : Colors.buttonTextDeactivated);
    }

    @Override
    public int getColor() {
        return this.mouseOver ? Colors.buttonBackground : 0;
    }

    @Override
    public void onClick(int button) {
        if (button == 1) {
            GuiContextMenu contextMenu = new GuiContextMenu(this.screen);
            contextMenu.addContextMenuElement(new GuiButton(this.screen, "Edit").addActionListener(e -> this.edit()));
            contextMenu.addContextMenuElement(new GuiButton(this.screen, "Teleport").addActionListener(e -> this.teleport()).setClickable(this.mc.getEnableCheats()));
            contextMenu.addContextMenuElement(new GuiButton(this.screen, "Delete").addActionListener(e -> this.delete()));
            this.screen.add(contextMenu);
        } else {
            this.waypoint.visible = !this.waypoint.visible;
        }
        super.onClick(button);
    }

    public void edit() {
        this.utils.displayGui(new GuiEditWaypoint(this.screen, this.waypoint));
    }

    public void teleport() {
        if (this.minimap.minecraftHelper.getEnableCheats()) {
            this.minimap.minecraftHelper.getThePlayer().teleportTo(this.waypoint.x, this.waypoint.y, this.waypoint.z);
        }
        this.utils.displayGui(null);
    }

    public void share() {
    }

    public void delete() {
        if (this.minimap.worldData.remove(this.waypoint)) {
            Minimap.log("Waypoint deleted: " + this.waypoint.name);
            this.guiWaypoints.init();
        } else {
            Minimap.log("Could not remove waypoint!");
        }
    }
}

