/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.mc.impl;

import b100.minimap.gui.CancelEventException;
import b100.minimap.gui.GuiScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Screen;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiWrapper
extends Screen {
    public GuiScreen minimapGui;
    public int mouseX;
    public int mouseY;
    public boolean skipInput = true;

    public GuiWrapper(GuiScreen minimapGui) {
        this.minimapGui = minimapGui;
        this.mc = minimapGui.minimap.mc;
    }

    public void render(int mouseX, int mouseY, float renderPartialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        if (this.minimapGui.isInitialized()) {
            this.minimapGui.cursorX = mouseX;
            this.minimapGui.cursorY = mouseY;
            while (Keyboard.next()) {
                int key = Keyboard.getEventKey();
                boolean repeat = Keyboard.isRepeatEvent();
                boolean pressed = Keyboard.getEventKeyState();
                char c = Keyboard.getEventCharacter();
                this.handleKeyEvent(key, c, pressed, repeat);
            }
            while (Mouse.next()) {
                int button = Mouse.getEventButton();
                boolean pressed = Mouse.getEventButtonState();
                this.handleMouseEvent(button, pressed);
            }
            this.handleScrolling(Mouse.getDWheel());
            if (this.skipInput) {
                this.skipInput = false;
            }
        }
    }

    public void handleKeyEvent(int key, char c, boolean pressed, boolean repeat) {
        if (this.skipInput) {
            return;
        }
        if (key == Keyboard.KEY_F11) {
            if (pressed) {
                this.mc.gameWindow.toggleFullscreen();
            }
        } else {
            try {
                this.minimapGui.keyEvent(key, c, pressed, repeat, this.mouseX, this.mouseY);
            }
            catch (CancelEventException cancelEventException) {
                // empty catch block
            }
        }
    }

    public void handleMouseEvent(int button, boolean pressed) {
        if (this.skipInput) {
            return;
        }
        if (button >= 0) {
            try {
                this.minimapGui.mouseEvent(button, pressed, this.mouseX, this.mouseY);
            }
            catch (CancelEventException cancelEventException) {
                // empty catch block
            }
        }
    }

    public void handleScrolling(int scrollAmount) {
        if (this.skipInput) {
            return;
        }
        if (scrollAmount != 0) {
            try {
                this.minimapGui.scrollEvent(scrollAmount, this.mouseX, this.mouseY);
            }
            catch (CancelEventException cancelEventException) {
                // empty catch block
            }
        }
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.minimapGui.onGuiClosed();
    }

    public void opened(Minecraft mc, int width, int height) {
        Keyboard.enableRepeatEvents((boolean)true);
        this.minimapGui.onGuiOpened();
    }
}

