/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.render;

import b100.minimap.Minimap;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL11;

public class MapTileManager {
    public static final int TILEWIDTH = 16;
    public Minimap minimap;
    public final int width;
    public int texture;
    private boolean[] tiles;

    public MapTileManager(Minimap minimap, int width) {
        this.minimap = minimap;
        this.width = width;
        this.tiles = new boolean[width * width];
        this.createTexture();
    }

    private void createTexture() {
        this.texture = this.minimap.minecraftHelper.generateTexture();
        GL11.glBindTexture((int)3553, (int)this.texture);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)(this.width * 16), (int)(this.width * 16), (int)0, (int)6408, (int)5121, (ByteBuffer)null);
    }

    public int getEmptyTile() {
        for (int i = 0; i < this.tiles.length; ++i) {
            if (this.tiles[i]) continue;
            return i;
        }
        return -1;
    }

    public void setTileInUse(int tile) {
        this.tiles[tile] = true;
    }

    public void setTileNotInUse(int tile) {
        this.tiles[tile] = false;
    }

    public void setTile(int tile, ByteBuffer color) {
        for (int i = 0; i < color.capacity() / 4; ++i) {
            int j = i << 2;
            byte a = color.get(j + 3);
            byte r = color.get(j + 2);
            byte g = color.get(j + 1);
            byte b = color.get(j + 0);
            color.put(j + 0, r);
            color.put(j + 1, g);
            color.put(j + 2, b);
            color.put(j + 3, a);
        }
        int tileX = tile % this.width;
        int tileY = tile / this.width;
        int x0 = tileX * 16;
        int y0 = tileY * 16;
        GL11.glBindTexture((int)3553, (int)this.texture);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)x0, (int)y0, (int)16, (int)16, (int)6408, (int)5121, (ByteBuffer)color);
        this.setTileInUse(tile);
    }
}

