/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.render;

import b100.minimap.Minimap;
import b100.minimap.render.block.BlockRenderManager;
import b100.minimap.render.block.RenderType;
import b100.minimap.render.block.TileColors;
import b100.minimap.utils.Utils;
import java.nio.IntBuffer;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class MapTileRenderer {
    public Minimap minimap;
    public World world;
    public int worldHeight = 256;
    private int[] maxHeightCache = new int[324];
    private int[] minHeightCache = new int[324];

    public MapTileRenderer(Minimap minimap) {
        this.minimap = minimap;
    }

    public boolean render(IntBuffer colorBuffer, int posX, int posZ, int width, int height) {
        int z;
        int x;
        int j;
        int i;
        boolean rendered = false;
        if (this.world == null) {
            throw new NullPointerException();
        }
        BlockRenderManager blockColors = this.minimap.blockRenderManager;
        TileColors tileColors = this.minimap.tileColors;
        int worldHeight = 256;
        int shadeType = (Integer)this.minimap.config.mapConfig.shadeType.value;
        boolean lighting = (Boolean)this.minimap.config.mapConfig.lighting.value;
        boolean renderAll = (Boolean)this.minimap.config.mapConfig.renderAllBlocks.value;
        for (i = 0; i < 18; ++i) {
            block1: for (j = 0; j < 18; ++j) {
                x = (posX << 4) + i - 1;
                z = (posZ << 4) + j - 1;
                this.setHeight(this.minHeightCache, i, j, -1);
                this.setHeight(this.maxHeightCache, i, j, -1);
                boolean maxHeightSet = false;
                for (int y = 255; y >= 0; --y) {
                    int id = this.world.getBlockId(x, y, z);
                    RenderType renderType = blockColors.getRenderType(id);
                    if (renderAll && renderType == RenderType.INVISIBLE && id > 0) {
                        renderType = RenderType.OPAQUE;
                    }
                    if (renderType != RenderType.INVISIBLE) {
                        rendered = true;
                        if (!maxHeightSet) {
                            this.setHeight(this.maxHeightCache, i, j, y);
                            maxHeightSet = true;
                        }
                    }
                    if (renderType != RenderType.OPAQUE) continue;
                    this.setHeight(this.minHeightCache, i, j, y);
                    continue block1;
                }
            }
        }
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                x = (posX << 4) + i;
                z = (posZ << 4) + j;
                int color = 0;
                int i0 = i + 1;
                int j0 = j + 1;
                int minHeight = this.getHeight(this.minHeightCache, i0, j0);
                int maxHeight = this.getHeight(this.maxHeightCache, i0, j0);
                if (minHeight != -1 && maxHeight != -1) {
                    int y0;
                    for (int y = minHeight; y <= maxHeight; ++y) {
                        int id = this.world.getBlockId(x, y, z);
                        Block block = Blocks.getBlock((int)id);
                        RenderType renderType = blockColors.getRenderType(id);
                        if (renderAll && renderType == RenderType.INVISIBLE && id > 0) {
                            renderType = RenderType.OPAQUE;
                        }
                        if (renderType == RenderType.OPAQUE) {
                            color = tileColors.getTileColor(this.world, x, y, z, block);
                            color = Utils.multiplyColor(color, ((BlockColor)BlockColorDispatcher.getInstance().getDispatch((Object)block)).getWorldColor((WorldSource)this.world, x, y, z));
                            if (!lighting) continue;
                            color = Utils.multiplyColor(color, block.getBlockBrightness((WorldSource)this.world, x, y + 1, z));
                            continue;
                        }
                        if (renderType != RenderType.TRANSPARENT) continue;
                        int transparentColor = tileColors.getTileColor(this.world, x, y, z, block);
                        transparentColor = Utils.multiplyColor(transparentColor, ((BlockColor)BlockColorDispatcher.getInstance().getDispatch((Object)block)).getWorldColor((WorldSource)this.world, x, y, z));
                        if (lighting) {
                            transparentColor = Utils.multiplyColor(transparentColor, block.getBlockBrightness((WorldSource)this.world, x, y + 1, z));
                        }
                        color = Utils.mixColor(color, transparentColor, 0.5f);
                    }
                    float brightness = 1.0f;
                    if (shadeType == 0) {
                        y0 = this.getHeight(this.maxHeightCache, i0, j0 + 1);
                        int y1 = this.getHeight(this.maxHeightCache, i0 + 1, j0);
                        int y2 = this.getHeight(this.maxHeightCache, i0, j0 - 1);
                        int y3 = this.getHeight(this.maxHeightCache, i0 - 1, j0);
                        if (y0 > maxHeight || y1 > maxHeight || y2 > maxHeight || y3 > maxHeight) {
                            brightness *= 0.75f;
                        }
                    } else if (shadeType == 1) {
                        y0 = this.getHeight(this.maxHeightCache, i0, j0 - 1);
                        int y1 = this.getHeight(this.maxHeightCache, i0 - 1, j0 - 1);
                        int y2 = this.getHeight(this.maxHeightCache, i0 - 1, j0);
                        int brightCount = 0;
                        int darkCount = 0;
                        if (y0 < maxHeight) {
                            ++brightCount;
                        }
                        if (y1 < maxHeight) {
                            ++brightCount;
                        }
                        if (y2 < maxHeight) {
                            ++brightCount;
                        }
                        if (y0 > maxHeight) {
                            ++darkCount;
                        }
                        if (y1 > maxHeight) {
                            ++darkCount;
                        }
                        if (y2 > maxHeight) {
                            ++darkCount;
                        }
                        if (brightCount > darkCount) {
                            brightness *= 1.25f;
                        }
                        if (darkCount > brightCount) {
                            brightness *= 0.65f;
                        }
                    } else if (shadeType == 2) {
                        int offset = 0;
                        offset += maxHeight - this.getHeight(this.maxHeightCache, i0 - 1, j0);
                        offset += maxHeight - this.getHeight(this.maxHeightCache, i0, j0 - 1);
                        offset += this.getHeight(this.maxHeightCache, i0 + 1, j0) - maxHeight;
                        offset += this.getHeight(this.maxHeightCache, i0, j0 + 1) - maxHeight;
                        offset = Utils.clamp(offset, -8, 8);
                        brightness = (float)offset / 8.0f / 2.0f + 1.0f;
                    }
                    color = Utils.multiplyColor(color, brightness);
                    color |= 0xFF000000;
                }
                colorBuffer.put(j * 16 + i, color);
            }
        }
        return rendered;
    }

    private void setHeight(int[] heightCache, int i, int j, int height) {
        heightCache[j * 18 + i] = height;
    }

    private int getHeight(int[] heightCache, int i, int j) {
        return heightCache[j * 18 + i];
    }

    public void onWorldChanged(World world) {
        this.world = world;
    }
}

