/*
 * Decompiled with CFR 0.152.
 */
package asmcompat.natrium;

import b100.asmloader.ClassTransformer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class Plugin
implements IMixinConfigPlugin {
    public List<ClassTransformer> classTransformers = new ArrayList<ClassTransformer>();

    public Plugin() {
        File modFile = Plugin.getModFile();
        JsonObject modJson = Plugin.readASMModJson(modFile);
        Plugin.print("Initializing Mod: " + modJson.get("modid").getAsString());
        ClassLoader classLoader = this.getClass().getClassLoader();
        Plugin.print("ClassLoader: " + classLoader);
        JsonArray transformers = modJson.get("transformers").getAsJsonArray();
        Plugin.print("Transformer Entries: ");
        int i = 0;
        while (i < transformers.size()) {
            Class<?> entryClass;
            String entryName = transformers.get(i).getAsString();
            Plugin.print("    " + entryName);
            try {
                entryClass = classLoader.loadClass(entryName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Loading Class: '" + entryName + "'!", e);
            }
            Object instance = null;
            try {
                instance = entryClass.getDeclaredConstructors()[0].newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Initializing Class: '" + entryClass.getName() + "'!", e);
            }
            if (Plugin.isTransformer(entryClass)) {
                ClassTransformer classTransformer = instance;
                this.classTransformers.add(classTransformer);
            }
            Class<?>[] subClasses = entryClass.getDeclaredClasses();
            int j = 0;
            while (j < subClasses.length) {
                Class<?> subClass = subClasses[j];
                if (Plugin.isTransformer(subClass)) {
                    Object subClassInstance;
                    block12: {
                        subClassInstance = null;
                        Constructor<?> constructor = subClass.getDeclaredConstructors()[0];
                        try {
                            constructor.setAccessible(true);
                            if (constructor.getParameterCount() == 0) {
                                subClassInstance = constructor.newInstance(new Object[0]);
                                break block12;
                            }
                            if (constructor.getParameterCount() == 1) {
                                subClassInstance = constructor.newInstance(instance);
                                break block12;
                            }
                            throw new RuntimeException("No acceptable constructor!");
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Could not instantiate '" + subClass.getName() + "'!", e);
                        }
                    }
                    ClassTransformer classTransformer = subClassInstance;
                    this.classTransformers.add(classTransformer);
                }
                ++j;
            }
            ++i;
        }
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Dummy");
        return list;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        String className = targetClassName.replace('.', '/').replace('$', '/');
        int i = 0;
        while (i < this.classTransformers.size()) {
            ClassTransformer classTransformer = this.classTransformers.get(i);
            if (classTransformer.accepts(className)) {
                Plugin.print("Transforming class '" + className + "' using transformer '" + classTransformer + "'!");
                classTransformer.transform(className, targetClass);
            }
            ++i;
        }
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public static void print(String string) {
        System.out.print("[ASMLoaderCompat] " + string + "\n");
    }

    public static File getModFile() {
        URI uri;
        ProtectionDomain protectionDomain = Plugin.class.getProtectionDomain();
        if (protectionDomain == null) {
            throw new NullPointerException("ProtectionDomain is null!");
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            throw new NullPointerException("CodeSource is null!");
        }
        URL url = codeSource.getLocation();
        if (url == null) {
            throw new NullPointerException("URL is null!");
        }
        try {
            uri = url.toURI();
        }
        catch (Exception e) {
            throw new RuntimeException("Converting URL to URI: '" + url + "'", e);
        }
        if (uri == null) {
            throw new NullPointerException("URI is null!");
        }
        return new File(uri);
    }

    public static JsonObject readASMModJson(File file) {
        ZipFile zipFile = null;
        InputStream in = null;
        try {
            zipFile = new ZipFile(file);
            ZipEntry entry = zipFile.getEntry("asmloader.mod.json");
            if (entry == null) {
                throw new NullPointerException("Missing asmloader.mod.json!");
            }
            in = zipFile.getInputStream(entry);
            JsonObject jsonObject = JsonParser.parseString((String)Plugin.readString(in)).getAsJsonObject();
            return jsonObject;
        }
        catch (Exception e) {
            throw new RuntimeException("Reading file: '" + file.getAbsolutePath() + "'!", e);
        }
        finally {
            try {
                zipFile.close();
            }
            catch (Exception exception) {}
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String readString(InputStream in) {
        BufferedReader br = null;
        StringBuilder str = new StringBuilder();
        try {
            try {
                String line;
                br = new BufferedReader(new InputStreamReader(in));
                while ((line = br.readLine()) != null) {
                    if (str.length() > 0) {
                        str.append('\n');
                    }
                    str.append(line);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Reading stream", e);
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
        return str.toString();
    }

    public static JsonElement readJson(String path, ClassLoader classLoader) {
        InputStream in = null;
        String string = null;
        try {
            try {
                in = classLoader.getResourceAsStream(path);
                string = Plugin.readString(in);
            }
            catch (Exception e) {
                throw new RuntimeException("Reading resource: '" + path + "'!", e);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return JsonParser.parseString((String)string);
    }

    public static boolean isTransformer(Class<?> clazz) {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == null) {
            return false;
        }
        if (superClass.getName().equals("b100.asmloader.ClassTransformer")) {
            return true;
        }
        return Plugin.isTransformer(superClass);
    }
}

