/*
 * Decompiled with CFR 0.152.
 */
package b100.natrium.asm.utils;

import b100.utils.InvalidCharacterException;
import b100.utils.StringReader;
import java.lang.reflect.Modifier;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InjectHelper {
    public final String listenerClass;
    public final String callbackInfoClass;

    public InjectHelper(String listenerClass, String callbackInfoClass) {
        this.listenerClass = listenerClass;
        this.callbackInfoClass = callbackInfoClass;
    }

    public InsnList createMethodCallInject(ClassNode classNode, MethodNode method, String listenerMethodName) {
        char returnType;
        InsnList insert = new InsnList();
        LabelNode labelStart = new LabelNode();
        LabelNode labelAfterReturn = new LabelNode();
        int callbackInfoIndex = method.localVariables.size();
        method.localVariables.add(new LocalVariableNode("callbackInfo" + callbackInfoIndex, "L" + this.callbackInfoClass + ";", null, labelStart, labelAfterReturn, callbackInfoIndex));
        ++method.maxLocals;
        insert.add((AbstractInsnNode)new TypeInsnNode(187, this.callbackInfoClass));
        insert.add((AbstractInsnNode)new InsnNode(89));
        insert.add((AbstractInsnNode)new MethodInsnNode(183, this.callbackInfoClass, "<init>", "()V"));
        insert.add((AbstractInsnNode)new VarInsnNode(58, callbackInfoIndex));
        StringBuilder listenerMethodDesc = new StringBuilder();
        listenerMethodDesc.append('(');
        if (!Modifier.isStatic(method.access)) {
            listenerMethodDesc.append('L');
            listenerMethodDesc.append(classNode.name);
            listenerMethodDesc.append(';');
        }
        listenerMethodDesc.append(method.desc.substring(1, method.desc.indexOf(41)));
        listenerMethodDesc.append('L').append(this.callbackInfoClass).append(';');
        listenerMethodDesc.append(")V");
        int parameterIndex = 0;
        if (!Modifier.isStatic(method.access)) {
            insert.add((AbstractInsnNode)new VarInsnNode(25, parameterIndex++));
        }
        String returnClass = null;
        try {
            StringReader reader = new StringReader(method.desc);
            reader.expectAndSkip('(');
            while (true) {
                int opcode;
                char c;
                if ((c = reader.getAndSkip()) == ')') {
                    returnType = reader.getAndSkip();
                    if (returnType == 'L') {
                        returnClass = reader.readUntilCharacter(';');
                    }
                    break;
                }
                boolean warn = false;
                if (c == 'I') {
                    opcode = 21;
                } else if (c == 'L') {
                    opcode = 25;
                    reader.readUntilCharacter(';');
                    reader.next();
                } else {
                    throw new InvalidCharacterException(reader);
                }
                insert.add((AbstractInsnNode)new VarInsnNode(opcode, parameterIndex++));
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Invalid method descriptor '" + method.desc + "' ?", e);
        }
        insert.add((AbstractInsnNode)labelStart);
        insert.add((AbstractInsnNode)new VarInsnNode(25, callbackInfoIndex));
        insert.add((AbstractInsnNode)new MethodInsnNode(184, this.listenerClass, listenerMethodName, listenerMethodDesc.toString()));
        insert.add((AbstractInsnNode)new VarInsnNode(25, callbackInfoIndex));
        insert.add((AbstractInsnNode)new MethodInsnNode(182, this.callbackInfoClass, "isCancelled", "()Z"));
        insert.add((AbstractInsnNode)new JumpInsnNode(153, labelAfterReturn));
        if (returnType == 'Z') {
            insert.add((AbstractInsnNode)new VarInsnNode(25, callbackInfoIndex));
            insert.add((AbstractInsnNode)new MethodInsnNode(182, this.callbackInfoClass, "getBooleanReturnValue", "()Z"));
            insert.add((AbstractInsnNode)new InsnNode(172));
        } else if (returnType == 'L') {
            insert.add((AbstractInsnNode)new VarInsnNode(25, callbackInfoIndex));
            insert.add((AbstractInsnNode)new MethodInsnNode(182, this.callbackInfoClass, "getReturnValue", "()Ljava/lang/Object;"));
            insert.add((AbstractInsnNode)new TypeInsnNode(192, returnClass));
            insert.add((AbstractInsnNode)new InsnNode(176));
        } else if (returnType == 'V') {
            insert.add((AbstractInsnNode)new InsnNode(177));
        } else {
            throw new RuntimeException("Unknown return type: " + returnType);
        }
        insert.add((AbstractInsnNode)labelAfterReturn);
        return insert;
    }
}

