/*
 * Decompiled with CFR 0.152.
 */
package solignomiki.writingsheets.gui;

import com.mojang.nbt.tags.CompoundTag;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketCustomPayload;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import solignomiki.writingsheets.WritingSheets;
import turniplabs.halplibe.HalpLibe;

public class ScreenSheetEditor
extends Screen {
    private static final String allowedCharacters = ChatAllowedCharacters.ALLOWED_CHARACTERS;
    protected ItemStack item;
    protected byte color;
    protected int xSize;
    protected int ySize;
    private int editLine = 0;
    private String title = "";
    private String[] text = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    private boolean canPlaySound = true;

    public ScreenSheetEditor(ItemStack item) {
        this.item = item;
        this.color = (byte)15;
        this.xSize = 176;
        this.ySize = 166;
        CompoundTag nbt = item.getData();
        CompoundTag sheetData = nbt.getCompound("SheetData");
        for (int i = 0; i < 16; ++i) {
            String textLine;
            this.text[i] = textLine = sheetData.getString("Text_" + i);
        }
    }

    public void render(int mouseX, int mouseY, float f) {
        this.renderBackground();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.loadTexture("/assets/writingsheets/textures/gui/sheet_2.png").bind();
        int widthBG = this.width / 2 - 80;
        this.drawTexturedModalRect(widthBG, 10, 0, 0, 175, 221);
        this.title = this.item.hasCustomName() ? this.item.getCustomName() : this.item.getDisplayName();
        this.drawString(this.font, this.title, 10, 10, -1);
        for (int i = 0; i < 16; ++i) {
            this.drawStringNoShadow(this.font, TextFormatting.get((int)this.color) + this.text[i], this.width / 2 - 57, 25 + i * 12, 0xFFFFFF);
            if (i != this.editLine) continue;
            int textWidth = this.font.getStringWidth(this.text[i]);
            this.drawStringNoShadow(this.font, TextFormatting.get((int)this.color) + "> ", this.width / 2 - 57 - 10, 25 + i * 12, 0xFFFFFF);
            this.drawStringNoShadow(this.font, TextFormatting.get((int)this.color) + " <", this.width / 2 - 57 + textWidth + 3, 25 + i * 12, 0xFFFFFF);
        }
        super.render(mouseX, mouseY, f);
    }

    public void init() {
        this.buttons.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttons.add(new ButtonElement(0, this.width / 2 - 100, this.height / 4 + 170, I18n.getInstance().translateKey("gui.edit_label.button.done")));
    }

    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_ESCAPE) {
            this.save();
            this.mc.displayScreen((Screen)null);
        }
        if (eventKey == Keyboard.KEY_UP) {
            this.editLine = (this.editLine - 1 + 16) % 16;
        }
        if (eventKey == Keyboard.KEY_DOWN || eventKey == Keyboard.KEY_RETURN || eventKey == Keyboard.KEY_NUMPADENTER) {
            this.editLine = (this.editLine + 1) % 16;
        }
        if (eventKey == Keyboard.KEY_BACK && !this.text[this.editLine].isEmpty()) {
            this.text[this.editLine] = this.text[this.editLine].substring(0, this.text[this.editLine].length() - 1);
        }
        if ((allowedCharacters.indexOf(eventCharacter) >= 0 || Character.isLetterOrDigit(eventCharacter)) && this.font.getStringWidth(this.text[this.editLine]) < 125) {
            StringBuilder stringBuilder = new StringBuilder();
            String[] textArray = this.text;
            int editLine = this.editLine;
            textArray[editLine] = stringBuilder.append(textArray[editLine]).append(eventCharacter).toString();
        }
    }

    protected void buttonClicked(ButtonElement button) {
        this.save();
        this.mc.displayScreen((Screen)null);
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void save() {
        CompoundTag nbt = this.item.getData();
        CompoundTag sheetData = nbt.getCompound("SheetData");
        for (int i = 0; i < 16; ++i) {
            sheetData.putString("Text_" + i, this.text[i]);
        }
        nbt.putCompound("SheetData", sheetData);
        this.item.setData(nbt);
        if (HalpLibe.isClient && this.mc.currentWorld.isClientSide) {
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteOutput);
            try {
                for (String str : this.text) {
                    dataOutputStream.writeUTF(str);
                }
            }
            catch (IOException e) {
                WritingSheets.LOGGER.error("IOException occurred in encoding!", (Throwable)e);
            }
            byte[] data = byteOutput.toByteArray();
            if (data.length != 0) {
                this.mc.getSendQueue().addToSendQueue((Packet)new PacketCustomPayload("WritingSheets|Text", data));
            }
        }
        if (!sheetData.getBoolean("IsWritten")) {
            int emptyRows = 0;
            for (int i = 0; i < 16; ++i) {
                String textData = sheetData.getString("Text_" + i);
                if (textData != "") continue;
                ++emptyRows;
            }
            if (emptyRows < 16) {
                sheetData.putBoolean("IsWritten", true);
            }
        }
    }

    public void tick() {
        super.tick();
        this.canPlaySound = true;
    }

    public void playPageSound() {
        if (this.canPlaySound) {
            this.canPlaySound = false;
            Random r = new Random();
            this.mc.sndManager.playSound("random.page", SoundCategory.GUI_SOUNDS, 0.9f, 1.0f + (r.nextFloat() - r.nextFloat()) * 0.3f);
        }
    }
}

