/*
 * Decompiled with CFR 0.152.
 */
package dev.joee.vinyl.file;

import dev.joee.vinyl.Vinyl;
import dev.joee.vinyl.file.FileManagerBase;
import dev.joee.vinyl.gui.ScreenDownloadMusic;
import dev.joee.vinyl.mixin.SaveHandlerBaseMixin;
import dev.joee.vinyl.network.PacketAudioChunk;
import dev.joee.vinyl.network.PacketAudioReceived;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.net.handler.PacketHandlerClient;
import net.minecraft.core.net.packet.Packet;
import org.apache.commons.lang3.ArrayUtils;

@Environment(value=EnvType.CLIENT)
public class FileManagerClient
extends FileManagerBase {
    public static final FileManagerClient instance = new FileManagerClient();
    private final Map<Integer, byte[]> fileBytes = new HashMap<Integer, byte[]>();

    @Override
    public File getAudioDir() {
        return Vinyl.SOUNDS.rootFile;
    }

    @Override
    public File getWorldAudioDir() {
        Minecraft mc = Minecraft.getMinecraft();
        SaveHandlerBaseMixin saveHandler = (SaveHandlerBaseMixin)mc.currentWorld.getSaveHandler();
        return new File(saveHandler.invokeGetSaveDirectory(), "vinyl/sounds/");
    }

    public synchronized void handleChunk(PacketAudioChunk chunk, PacketHandlerClient packetHandler) {
        byte[] currentData;
        if (this.fileBytes.containsKey(chunk.fileId)) {
            currentData = this.fileBytes.get(chunk.fileId);
            byte[] newData = ArrayUtils.addAll((byte[])currentData, (byte[])chunk.data);
            this.fileBytes.put(chunk.fileId, newData);
        } else {
            this.fileBytes.put(chunk.fileId, chunk.data);
        }
        if (chunk.isFinalChunk() && chunk.filePath.endsWith(".ogg")) {
            currentData = this.fileBytes.get(chunk.fileId);
            byte[] trimmedData = Arrays.copyOfRange(currentData, 0, chunk.size);
            Vinyl.SOUNDS.saveSound(chunk.filePath, trimmedData);
            this.fileBytes.remove(chunk.fileId);
            packetHandler.addToSendQueue((Packet)new PacketAudioReceived(chunk.fileId));
            Screen currentScreen = Minecraft.getMinecraft().currentScreen;
            if (currentScreen instanceof ScreenDownloadMusic) {
                ((ScreenDownloadMusic)currentScreen).incrementLoadingBar();
            }
        }
    }
}

