/*
 * Decompiled with CFR 0.152.
 */
package dev.joee.vinyl.item;

import com.mojang.nbt.tags.CompoundTag;
import dev.joee.vinyl.Vinyl;
import dev.joee.vinyl.network.NetworkMessagePlayMusic;
import dev.joee.vinyl.tileentity.TileEntityVinylJukebox;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.entity.TileEntityJukebox;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class ItemCustomRecord
extends Item {
    private static final Pattern FORMAT_PATTERN = Pattern.compile("\u00a7[0-9a-fk-or]|\u00a7<.*?>");

    public ItemCustomRecord() {
        super("record.custom", String.format("%s:item/%s", "vinyl", "record.custom"), Vinyl.CONFIG.getItemId("customRecordId"));
    }

    public CompoundTag getDefaultTag() {
        CompoundTag tag = super.getDefaultTag();
        tag.putString("RecordName", "");
        tag.putString("RecordArtist", "");
        tag.putString("RecordFilePath", "");
        tag.putInt("PrimaryColor", 0);
        tag.putInt("SecondaryColor", 0);
        return tag;
    }

    public String getTranslatedDescription(ItemStack stack) {
        CompoundTag tag = stack.getData();
        TextFormatting primary = TextFormatting.get((int)(15 - tag.getInteger("PrimaryColor")));
        TextFormatting secondary = TextFormatting.get((int)(15 - tag.getInteger("SecondaryColor")));
        String text = primary + stack.getData().getString("RecordArtist") + TextFormatting.LIGHT_GRAY + " - " + secondary + stack.getData().getString("RecordName");
        return ItemCustomRecord.propagateFormattingToWords(text);
    }

    public boolean onUseItemOnBlock(ItemStack stack, Player player, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        if (world.getBlockId(x, y, z) == Blocks.JUKEBOX.id() && world.getBlockMetadata(x, y, z) == 0) {
            if (!world.isClientSide) {
                this.playMusic(stack, world, x, y, z);
                this.storeRecordInJukebox(stack, world, x, y, z);
                stack.consumeItem(player);
            }
            return true;
        }
        return false;
    }

    public void onUseByActivator(ItemStack stack, TileEntityActivator activatorBlock, World world, Random random, int blockX, int blockY, int blockZ, double offX, double offY, double offZ, Direction direction) {
        int z;
        int y;
        int x = blockX + direction.getOffsetX();
        int b = world.getBlockId(x, y = blockY + direction.getOffsetY(), z = blockZ + direction.getOffsetZ());
        if (b == Blocks.JUKEBOX.id() && world.getBlockMetadata(x, y, z) == 0) {
            this.playMusic(stack, world, x, y, z);
            this.storeRecordInJukebox(stack, world, x, y, z);
            stack.consumeItem(null);
        }
    }

    private void playMusic(ItemStack stack, World world, int x, int y, int z) {
        CompoundTag tag = stack.getData();
        NetworkHandler.sendToAllAround((double)x, (double)y, (double)z, (double)64.0, (int)world.dimension.id, (NetworkMessage)new NetworkMessagePlayMusic(tag.getString("RecordName"), tag.getString("RecordArtist"), tag.getString("RecordFilePath"), x, y, z));
    }

    private void storeRecordInJukebox(ItemStack stack, World world, int x, int y, int z) {
        Object tileEntity = world.getTileEntity(x, y, z);
        if (tileEntity instanceof TileEntityJukebox) {
            tileEntity = new TileEntityVinylJukebox((TileEntityJukebox)tileEntity);
            world.setTileEntity(x, y, z, tileEntity);
        }
        if (tileEntity instanceof TileEntityVinylJukebox) {
            TileEntityVinylJukebox te = (TileEntityVinylJukebox)((Object)tileEntity);
            te.record = stack.getItem().id;
            te.recordTag = stack.getData();
            te.setChanged();
            world.setBlockMetadataWithNotify(x, y, z, 1);
        }
    }

    private static String propagateFormattingToWords(String input) {
        CharSequence[] words = input.split(" ");
        StringBuilder currentFormat = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            Matcher matcher = FORMAT_PATTERN.matcher(words[i]);
            if (!matcher.find()) {
                words[i] = currentFormat + (String)words[i];
                continue;
            }
            String formatting = matcher.group();
            words[i] = currentFormat + (String)words[i];
            currentFormat.append(formatting);
        }
        return String.join((CharSequence)" ", words);
    }
}

