/*
 * Decompiled with CFR 0.152.
 */
package lunaticuncle.btalightoverlay;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import lunaticuncle.btalightoverlay.Configs;
import lunaticuncle.btalightoverlay.PosInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicGlass;
import net.minecraft.core.block.BlockLogicGlassTinted;
import net.minecraft.core.block.BlockLogicIce;
import net.minecraft.core.block.BlockLogicLayerBase;
import net.minecraft.core.block.BlockLogicLayerLeaves;
import net.minecraft.core.block.BlockLogicLeavesBase;
import net.minecraft.core.block.BlockLogicPressurePlate;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class OverlayRenderer {
    private boolean canRender = false;
    private List<PosInfo> surroundingPos = new ArrayList<PosInfo>();
    private long ticks;
    private boolean isWorldInit = false;
    private final Color colorNumberBlockDark = this.decode(Configs.Colors.NUMBER_BLOCK_DARK);
    private final Color colorNumberBlockLit = this.decode(Configs.Colors.NUMBER_BLOCK_LIT);
    private final Color colorNumberSkyDark = this.decode(Configs.Colors.NUMBER_SKY_DARK);
    private final Color colorNumberSkyLit = this.decode(Configs.Colors.NUMBER_SKY_LIT);
    private final Color colorMarkerDark = this.decode(Configs.Colors.MARKER_DARK);
    private final Color colorMarkerBlockLit = this.decode(Configs.Colors.MARKER_BLOCK_LIT);
    private final Color colorMarkerSkyLit = this.decode(Configs.Colors.MARKER_SKY_LIT);

    public void update(Minecraft mc) {
        int interval;
        if (!this.canRender) {
            this.isWorldInit = false;
            return;
        }
        PlayerLocal thePlayer = mc.thePlayer;
        int n = Configs.General.UPDATE_INTERVAL > 20 ? 20 : (interval = Configs.General.UPDATE_INTERVAL < 1 ? 1 : Configs.General.UPDATE_INTERVAL);
        if (this.ticks > (long)interval || !this.isWorldInit) {
            this.ticks = 0L;
            this.updatePos(thePlayer);
            this.isWorldInit = true;
        }
        this.updateLightLevels(mc);
        ++this.ticks;
    }

    public void draw(Minecraft mc, float partialTick) {
        if (!this.canRender) {
            this.isWorldInit = false;
            return;
        }
        ICamera cam = mc.activeCamera;
        CameraFrustum frustum = new CameraFrustum(cam);
        WorldClient world = mc.currentWorld;
        PlayerLocal thePlayer = mc.thePlayer;
        Tessellator tessellator = Tessellator.instance;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-cam.getX(partialTick)), (double)(-cam.getY(partialTick)), (double)(-cam.getZ(partialTick)));
        for (PosInfo queryPos : this.surroundingPos) {
            BlockLogic block;
            if (this.canSkipDraw(frustum, (World)world, queryPos, partialTick)) continue;
            double offsetY = 0.0;
            if (Blocks.blocksList[world.getBlockId(queryPos.x, queryPos.y, queryPos.z)] != null && (block = Blocks.blocksList[world.getBlockId(queryPos.x, queryPos.y, queryPos.z)].getLogic()) instanceof BlockLogicLayerBase) {
                int meta = world.getBlockMetadata(queryPos.x, queryPos.y, queryPos.z);
                if (block instanceof BlockLogicLayerLeaves) {
                    meta -= 128;
                }
                offsetY = (double)(meta + 1) * 0.125;
            }
            String numbersMode = Configs.General.NUMBERS_MODE;
            String markersCondition = Configs.General.MARKERS_CONDITION;
            if (!numbersMode.equalsIgnoreCase("none")) {
                this.drawNumber(mc.font, queryPos, Direction.getHorizontalDirection((double)thePlayer.yRot), offsetY);
            }
            if (markersCondition.equalsIgnoreCase("never")) continue;
            this.drawMarker(tessellator, queryPos, offsetY);
        }
        GL11.glPopMatrix();
    }

    private PosInfo getPlayerCoordinate(PlayerLocal thePlayer) {
        double x = MathHelper.floor((double)thePlayer.x);
        double y = MathHelper.floor((double)thePlayer.y);
        double z = MathHelper.floor((double)thePlayer.z);
        return new PosInfo((int)x, (int)y, (int)z);
    }

    private void drawNumber(Font fontRenderer, PosInfo pos, Direction facing, double offsetY) {
        Color color;
        int length;
        String num;
        double x = pos.x;
        double y = (double)(pos.y - 1) + offsetY;
        double z = pos.z;
        GL11.glEnable((int)2884);
        GL11.glPushMatrix();
        double offset = 0.0625;
        switch (facing) {
            case NORTH: {
                GL11.glTranslated((double)(x + offset * 8.5), (double)(y + 1.01), (double)(z + offset * 5.25));
                break;
            }
            case EAST: {
                GL11.glTranslated((double)(x + offset * 10.75), (double)(y + 1.01), (double)(z + offset * 8.5));
                break;
            }
            case SOUTH: {
                GL11.glTranslated((double)(x + offset * 7.5), (double)(y + 1.01), (double)(z + offset * 10.75));
                break;
            }
            case WEST: {
                GL11.glTranslated((double)(x + offset * 5.25), (double)(y + 1.01), (double)(z + offset * 7.5));
                break;
            }
        }
        GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
        switch (facing) {
            case NORTH: {
                break;
            }
            case EAST: {
                GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case SOUTH: {
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case WEST: {
                GL11.glRotated((double)270.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
        }
        GL11.glPushMatrix();
        GL11.glScaled((double)0.05, (double)0.05, (double)0.05);
        String mode = Configs.General.NUMBERS_MODE;
        if (mode.equalsIgnoreCase("block") || mode.equalsIgnoreCase("both")) {
            num = String.valueOf(pos.lightLevelBlock);
            length = fontRenderer.getStringWidth(num);
            color = pos.lightLevelBlock == 0 ? this.colorNumberBlockDark : this.colorNumberBlockLit;
            fontRenderer.drawString(num, -(length / 2), 0, color.getRGB());
        }
        if (mode.equalsIgnoreCase("sky") || mode.equalsIgnoreCase("both")) {
            GL11.glPushMatrix();
            offset = 1.25;
            GL11.glTranslated((double)(offset * 2.5), (double)(offset * 4.0), (double)-0.1);
            num = String.valueOf(pos.lightLevelSky);
            length = fontRenderer.getStringWidth(num);
            color = pos.lightLevelSky == 0 ? this.colorNumberSkyDark : this.colorNumberSkyLit;
            fontRenderer.drawString(num, -(length / 2), 0, color.getRGB());
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glDisable((int)2884);
    }

    private void drawMarker(Tessellator tessellator, PosInfo pos, double offsetY) {
        if (pos.lightLevelBlock > 0 && !Configs.General.MARKERS_CONDITION.equalsIgnoreCase("always")) {
            return;
        }
        Color color = this.colorMarkerBlockLit;
        if (pos.lightLevelBlock == 0) {
            color = pos.lightLevelSky > 4 ? this.colorMarkerSkyLit : this.colorMarkerDark;
        }
        double x = pos.x;
        double y = (double)pos.y + offsetY + 0.03;
        double z = pos.z;
        double offset = 0.0625;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2884);
        GL11.glLineWidth((float)2.0f);
        GL11.glColor3d((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue());
        tessellator.startDrawing(1);
        tessellator.addVertex(x + offset, y, z + offset);
        tessellator.addVertex(x + 1.0 - offset, y, z + 1.0 - offset);
        tessellator.addVertex(x + offset, y, z + 1.0 - offset);
        tessellator.addVertex(x + 1.0 - offset, y, z + offset);
        tessellator.draw();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2884);
    }

    private boolean canSkipDraw(CameraFrustum frustum, World world, PosInfo pos, float partialTick) {
        int x = pos.x;
        int y = pos.y;
        int z = pos.z;
        return !this.canSpawnAt(world, x, y, z) || this.isTopSolid(world, x, y, z) || !frustum.isVisible(AABB.getPermanentBB((double)(x + 1), (double)y, (double)(z + 1), (double)(x - 1), (double)y, (double)(z - 1)), partialTick);
    }

    private boolean canSpawnAt(World world, int x, int y, int z) {
        return world.isBlockNormalCube(x, y - 1, z) && !world.isBlockNormalCube(x, y, z) && !world.getBlockMaterial(x, y, z).isLiquid();
    }

    private boolean isTopSolid(World world, int x, int y, int z) {
        if (Blocks.blocksList[world.getBlockId(x, y, z)] == null) {
            return false;
        }
        BlockLogic block = Blocks.blocksList[world.getBlockId(x, y, z)].getLogic();
        return block instanceof BlockLogicGlass || block instanceof BlockLogicGlassTinted || block instanceof BlockLogicIce || block instanceof BlockLogicLeavesBase || block instanceof BlockLogicPressurePlate;
    }

    public void toggleRender() {
        this.canRender = !this.canRender;
    }

    private void updatePos(PlayerLocal thePlayer) {
        int horizontalRange;
        this.surroundingPos = new ArrayList<PosInfo>();
        int n = Configs.General.HORIZONTAL_RANGE > 32 ? 32 : (horizontalRange = Configs.General.HORIZONTAL_RANGE < 1 ? 1 : Configs.General.HORIZONTAL_RANGE);
        int verticalRange = Configs.General.VERTICAL_RANGE > 32 ? 32 : (Configs.General.VERTICAL_RANGE < 1 ? 1 : Configs.General.VERTICAL_RANGE);
        PosInfo playerCoordinate = this.getPlayerCoordinate(thePlayer);
        for (int dx = -horizontalRange; dx <= horizontalRange; ++dx) {
            for (int dy = -verticalRange; dy <= verticalRange; ++dy) {
                for (int dz = -horizontalRange; dz <= horizontalRange; ++dz) {
                    PosInfo queryPos = new PosInfo(playerCoordinate.x + dx, playerCoordinate.y + dy, playerCoordinate.z + dz);
                    this.surroundingPos.add(queryPos);
                }
            }
        }
    }

    private void updateLightLevels(Minecraft mc) {
        WorldClient world = mc.currentWorld;
        for (PosInfo queryPos : this.surroundingPos) {
            queryPos.lightLevelBlock = world.getSavedLightValue(LightLayer.Block, queryPos.x, queryPos.y, queryPos.z);
            queryPos.lightLevelSky = world.getSavedLightValue(LightLayer.Sky, queryPos.x, queryPos.y, queryPos.z);
        }
    }

    private Color decode(String nm) {
        try {
            return Color.decode(nm);
        }
        catch (NumberFormatException e) {
            return Color.white;
        }
    }
}

