/*
 * Decompiled with CFR 0.152.
 */
package bigsir.simplehealthindicator.render;

import bigsir.simplehealthindicator.SHIClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    public static long lastNano = 0L;
    public static Entity entity = null;
    private static final IconCoordinate CONTAINER = TextureRegistry.getTexture((String)"minecraft:gui/hud/heart/container");
    private static final IconCoordinate CONTAINER_BLINKING = TextureRegistry.getTexture((String)"minecraft:gui/hud/heart/container_blinking");
    private static final IconCoordinate FULL = TextureRegistry.getTexture((String)"minecraft:gui/hud/heart/full");
    private static final IconCoordinate HALF = TextureRegistry.getTexture((String)"minecraft:gui/hud/heart/half");
    private static final IconCoordinate FULL_BLINKING = TextureRegistry.getTexture((String)"minecraft:gui/hud/heart/full_blinking");
    private static final IconCoordinate HALF_BLINKING = TextureRegistry.getTexture((String)"minecraft:gui/hud/heart/half_blinking");

    public static void renderInfo(Minecraft mc, float partialTick, long systemNano) {
        int renderOrder = (Integer)SHIClient.renderOrder.value == 0 ? 1 : -1;
        long renderTimeLength = ((Integer)SHIClient.displayTime.value).intValue();
        Entity mouseOverEntity = RenderUtils.getMouseOverEntity(mc);
        if (entity != null && RenderUtils.entity.removed || (systemNano - lastNano) / 1000000L > renderTimeLength * 100L) {
            entity = null;
        }
        if (mouseOverEntity instanceof Mob) {
            RenderUtils.setTarget(mouseOverEntity);
        }
        double scale = 0.3 * ((double)((Integer)SHIClient.heartScale.value + 50) / 100.0);
        int heartsInRow = (Integer)SHIClient.maxHearts.value + 2;
        if (entity != null) {
            boolean heartsFlash;
            float brightness;
            float f = brightness = (Boolean)SHIClient.healthFullbright.value != false ? ((Float)SHIClient.healthBrightness.value).floatValue() : entity.getBrightness(partialTick);
            brightness = LightmapHelper.isLightmapEnabled() ? RenderUtils.applyGamma(brightness, ((Float)mc.gameSettings.brightness.value).floatValue()) : (brightness += 0.2f);
            int hearts = MathHelper.ceilInt((int)((Mob)entity).getMaxHealth(), (int)2);
            int length = Math.min(hearts, heartsInRow);
            int rows = MathHelper.ceilInt((int)hearts, (int)heartsInRow);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(-mc.activeCamera.getX(partialTick)), (double)(-mc.activeCamera.getY(partialTick)), (double)(-mc.activeCamera.getZ(partialTick)));
            float heightOffset = entity.getHeadHeight() + (((Mob)RenderUtils.entity).nickname.isEmpty() ? 0.6f : 0.85f);
            GL11.glTranslated((double)RenderUtils.lerp(RenderUtils.entity.xo, RenderUtils.entity.x, partialTick), (double)(RenderUtils.lerp(RenderUtils.entity.yo, RenderUtils.entity.y, partialTick) + (double)heightOffset), (double)RenderUtils.lerp(RenderUtils.entity.zo, RenderUtils.entity.z, partialTick));
            GL11.glRotatef((float)(180.0f - (float)mc.activeCamera.getYRot(partialTick)), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)((float)(-mc.activeCamera.getXRot(partialTick))), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslated((double)(-((double)length - (double)(length - 1) / 9.0) / 2.0 * scale), (double)0.0, (double)0.0);
            Tessellator tessellator = Tessellator.instance;
            GL11.glEnable((int)3553);
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.001);
            boolean bl = heartsFlash = RenderUtils.entity.heartsFlashTime / 3 % 2 == 1;
            if (RenderUtils.entity.heartsFlashTime < 10) {
                heartsFlash = false;
            }
            boolean fillOrder = (Integer)SHIClient.fillOrder.value == 0;
            int yOff = fillOrder ? (rows - 1) * 4 : 0;
            double zOff = (double)(rows - 1) * 0.001;
            for (int i = 0; i < rows; ++i) {
                int xOff = 0;
                for (int j = 0; j < Math.min(hearts - i * heartsInRow, heartsInRow); ++j) {
                    RenderUtils.drawHeart(tessellator, heartsFlash ? CONTAINER_BLINKING : CONTAINER, xOff, yOff, zOff, scale, brightness);
                    xOff += 8;
                    zOff -= 0.001 * (double)(fillOrder ? renderOrder : -renderOrder);
                }
                yOff -= fillOrder ? 4 : -4;
            }
            int health = ((Mob)entity).getHealth();
            int healthFull = MathHelper.ceilInt((int)health, (int)2);
            boolean drawHalf = health % 2 != 0;
            int healthRow = MathHelper.ceilInt((int)healthFull, (int)heartsInRow);
            yOff = fillOrder ? (rows - 1) * 4 : 0;
            zOff = (double)(rows - 1) * 0.001 + 0.001;
            for (int i = 0; i < healthRow; ++i) {
                int xOff = 0;
                int heartsRemaining = Math.min(healthFull - i * heartsInRow, heartsInRow);
                for (int j = 0; j < heartsRemaining; ++j) {
                    RenderUtils.drawHeart(tessellator, drawHalf && i == healthRow - 1 && j == heartsRemaining - 1 ? HALF : FULL, xOff, yOff, zOff, scale, brightness);
                    xOff += 8;
                    zOff -= 0.001 * (double)(fillOrder ? renderOrder : -renderOrder);
                }
                yOff -= fillOrder ? 4 : -4;
            }
            GL11.glPopMatrix();
        }
    }

    private static void drawHeart(Tessellator tessellator, IconCoordinate icon, int xOffset, int yOffset, double zOffset, double scale, float brightness) {
        double posX = (double)xOffset / 9.0;
        double posY = (double)yOffset / 9.0;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.startDrawing(7);
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        icon.parentAtlas.bind();
        tessellator.addVertexWithUV(posX * scale, posY * scale, zOffset, icon.getIconUMin() + 1.0E-4, icon.getIconVMax() - 1.0E-4);
        tessellator.addVertexWithUV((posX + 1.0) * scale, posY * scale, zOffset, icon.getIconUMax() - 1.0E-4, icon.getIconVMax() - 1.0E-4);
        tessellator.addVertexWithUV((posX + 1.0) * scale, (posY + 1.0) * scale, zOffset, icon.getIconUMax() - 1.0E-4, icon.getIconVMin() + 1.0E-4);
        tessellator.addVertexWithUV(posX * scale, (posY + 1.0) * scale, zOffset, icon.getIconUMin() + 1.0E-4, icon.getIconVMin() + 1.0E-4);
        tessellator.draw();
    }

    private static Entity getMouseOverEntity(Minecraft mc) {
        return mc.objectMouseOver == null ? null : mc.objectMouseOver.entity;
    }

    private static double lerp(double old, double curr, float partialTick) {
        return old + (curr - old) * (double)partialTick;
    }

    public static void setTarget(Entity mob) {
        entity = mob;
        lastNano = System.nanoTime();
    }

    public static float applyGamma(float color, float gamma) {
        float color2 = 1.0f - color;
        color2 = 1.0f - color2 * color2 * color2 * color2;
        return color * (1.0f - gamma) + color2 * gamma;
    }
}

