/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.util;

import io.github.prospector.modmenu.ModMenu;
import io.github.prospector.modmenu.gui.ModListScreen;
import io.github.prospector.modmenu.util.RenderUtils;
import java.util.Calendar;
import java.util.Map;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.client.Minecraft;
import net.minecraft.core.lang.I18n;

public class BadgeRenderer {
    protected int startX;
    protected int startY;
    protected int badgeX;
    protected int badgeY;
    protected int badgeMax;
    protected ModContainer container;
    protected ModMetadata metadata;
    protected Minecraft client;
    protected final ModListScreen screen;

    public BadgeRenderer(Minecraft client, int startX, int startY, int endX, ModContainer container, ModListScreen screen) {
        this.startX = startX;
        this.startY = startY;
        this.badgeMax = endX;
        this.container = container;
        this.metadata = container.getMetadata();
        this.screen = screen;
        this.client = client;
    }

    public void draw(int mouseX, int mouseY) {
        I18n i18n = I18n.getInstance();
        this.badgeX = this.startX;
        this.badgeY = this.startY;
        if (ModMenu.LIBRARY_MODS.contains(this.metadata.getId())) {
            this.drawBadge(i18n.translateKey("modmenu.library"), -2012163944, -2012978874, mouseX, mouseY);
        }
        if (ModMenu.CLIENTSIDE_MODS.contains(this.metadata.getId())) {
            this.drawBadge(i18n.translateKey("modmenu.clientsideOnly"), -2008841245, -2012330343, mouseX, mouseY);
        }
        if (ModMenu.DEPRECATED_MODS.contains(this.metadata.getId())) {
            this.drawBadge(i18n.translateKey("modmenu.deprecated"), -8121306, -11334633, mouseX, mouseY);
        }
        if (ModMenu.PATCHWORK_FORGE_MODS.contains(this.metadata.getId())) {
            this.drawBadge(i18n.translateKey("modmenu.forge"), -2005104221, -2011157437, mouseX, mouseY);
        }
        if (this.metadata.getId().equals("minecraft")) {
            this.drawBadge(i18n.translateKey("modmenu.minecraft"), -2000896836, -2007805101, mouseX, mouseY);
        }
        if (ModMenu.CUSTOM_BADGE_MODS.containsKey(this.metadata.getId())) {
            Map<String, Map.Entry<Integer, Integer>> map = ModMenu.CUSTOM_BADGE_MODS.get(this.metadata.getId());
            for (Map.Entry<String, Map.Entry<Integer, Integer>> entry : map.entrySet()) {
                this.drawBadge(entry.getKey(), entry.getValue().getKey(), entry.getValue().getValue(), mouseX, mouseY);
            }
        }
        if (Calendar.getInstance().get(2) == 3 && Calendar.getInstance().get(5) == 1) {
            if (this.metadata.getId().equals(new String(new byte[]{109, 111, 100, 109, 101, 110, 117}))) {
                this.drawBadge(new String(new byte[]{-30, -100, -104, 32, 86, 105, 114, 117, 115, 32, 68, 101, 116, 101, 99, 116, 101, 100}), -1996545502, -2004940792, mouseX, mouseY);
            } else if (this.metadata.getId().contains(new String(new byte[]{116, 97, 116, 101, 114}))) {
                this.drawBadge(new String(new byte[]{116, 97, 116, 101, 114}), -1997819093, -2003209966, mouseX, mouseY);
            } else {
                this.drawBadge(new String(new byte[]{-30, -100, -108, 32, 98, 121, 32, 77, 99, 65, 102, 101, 101}), -2011300024, -2012780274, mouseX, mouseY);
            }
        }
    }

    public void drawBadge(String text, int outlineColor, int fillColor, int mouseX, int mouseY) {
        int width = this.client.font.getStringWidth(text) + 6;
        if (this.badgeX + width < this.badgeMax) {
            RenderUtils.INSTANCE.drawBadge(this.client.font, this.badgeX, this.badgeY, width, text, outlineColor, fillColor, 0xCACACA);
            this.badgeX += width + 3;
        }
    }

    public ModMetadata getMetadata() {
        return this.metadata;
    }
}

