/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.config;

import io.github.prospector.modmenu.ModMenu;
import io.github.prospector.modmenu.config.ModMenuConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ModMenuConfigManager {
    private static Path file;
    private static ModMenuConfig config;

    private static void prepareBiomeConfigFile() {
        if (file != null) {
            return;
        }
        file = FabricLoader.getInstance().getConfigDir().resolve("modmenu.json");
    }

    public static ModMenuConfig initializeConfig() {
        if (config != null) {
            return config;
        }
        config = new ModMenuConfig();
        ModMenuConfigManager.load();
        return config;
    }

    private static void load() {
        ModMenuConfigManager.prepareBiomeConfigFile();
        try {
            if (Files.notExists(file, new LinkOption[0])) {
                ModMenuConfigManager.save();
            }
            if (Files.exists(file, new LinkOption[0])) {
                BufferedReader br = Files.newBufferedReader(file);
                config = (ModMenuConfig)ModMenu.GSON.fromJson((Reader)br, ModMenuConfig.class);
            }
        }
        catch (IOException e) {
            ModMenu.LOGGER.error("Couldn't load Mod Menu configuration file; reverting to defaults", (Throwable)e);
        }
    }

    public static void save() {
        ModMenuConfigManager.prepareBiomeConfigFile();
        String jsonString = ModMenu.GSON.toJson((Object)config);
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(jsonString);
        }
        catch (IOException e) {
            ModMenu.LOGGER.error("Couldn't save Mod Menu configuration file", (Throwable)e);
        }
    }

    public static ModMenuConfig getConfig() {
        return config;
    }
}

