/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.gui;

import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.util.helper.MathHelper;
import org.jspecify.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.spongepowered.include.com.google.common.collect.Lists;

@Environment(value=EnvType.CLIENT)
public abstract class EntryListWidget<E extends Entry<E>>
extends Screen {
    protected static final int TOP_PADDING = 4;
    protected static final int SCROLLBAR_WIDTH = 6;
    protected final Minecraft minecraft;
    protected final int itemHeight;
    private final List<E> children = new EntryList();
    protected int top;
    protected int bottom;
    protected int right;
    protected int left;
    private double scrollAmount;
    protected boolean renderSelection = true;
    protected boolean shouldRenderHeader;
    protected int headerHeight;
    private E selected;
    private E focused;

    protected EntryListWidget(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
        this.minecraft = minecraft;
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.itemHeight = itemHeight;
        this.left = 0;
        this.right = width;
    }

    public void setRenderSelection(boolean bl) {
        this.renderSelection = bl;
    }

    protected void setRenderHeader(boolean bl, int i) {
        this.shouldRenderHeader = bl;
        this.headerHeight = i;
        if (!bl) {
            this.headerHeight = 0;
        }
    }

    public int getRowWidth() {
        return 220;
    }

    public @Nullable E getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable E entry) {
        this.selected = entry;
    }

    public @Nullable E getFocused() {
        return this.focused;
    }

    public void setFocused(E focused) {
        this.focused = focused;
    }

    public final List<E> children() {
        return this.children;
    }

    protected final void clearEntries() {
        this.children.clear();
    }

    protected void replaceEntries(Collection<E> collection) {
        this.children.clear();
        this.children.addAll(collection);
    }

    protected E getEntry(int index) {
        return (E)((Object)((Entry)((Object)this.children().get(index))));
    }

    protected int addEntry(E entry) {
        this.children.add(entry);
        return this.children.size() - 1;
    }

    protected int getItemCount() {
        return this.children().size();
    }

    protected boolean isSelectedItem(int index) {
        return Objects.equals(this.getSelected(), this.children().get(index));
    }

    protected @Nullable E getEntryAtPosition(double mouseX, double mouseY) {
        int halfRowWidth = this.getRowWidth() / 2;
        int centerX = this.left + this.width / 2;
        int rowLeft = centerX - halfRowWidth;
        int rowRight = centerX + halfRowWidth;
        int yInList = MathHelper.floor((double)(mouseY - (double)this.top)) - this.headerHeight + (int)this.getScrollAmount() - 4;
        int rowIndex = yInList / this.itemHeight;
        if (mouseX >= (double)this.getScrollbarPosition() || mouseX < (double)rowLeft || mouseX > (double)rowRight) {
            return null;
        }
        if (yInList < 0 || rowIndex < 0 || rowIndex >= this.getItemCount()) {
            return null;
        }
        return (E)((Object)((Entry)((Object)this.children().get(rowIndex))));
    }

    public void updateSize(int width, int height, int top, int bottom) {
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
    }

    public void setLeftEdge(int leftEdge) {
        this.left = leftEdge;
        this.right = leftEdge + this.width;
    }

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected void onHeaderClicked(int relativeX, int relativeY) {
    }

    protected void renderHeader(int left, int top, Tessellator tessellator) {
    }

    public void renderBackground() {
    }

    protected void renderDecorations(int mouseX, int mouseY) {
    }

    public void render(int mouseX, int mouseY, float delta) {
        this.renderBackground();
        int scrollbarX = this.getScrollbarPosition();
        int scrollbarEndX = scrollbarX + 6;
        Tessellator tessellator = Tessellator.instance;
        this.minecraft.textureManager.bindTexture(this.minecraft.textureManager.loadTexture("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque(32, 32, 32);
        tessellator.addVertexWithUV((double)this.left, (double)this.bottom, 0.0, (double)((float)this.left / 32.0f), (double)((float)(this.bottom + (int)this.getScrollAmount()) / 32.0f));
        tessellator.addVertexWithUV((double)this.right, (double)this.bottom, 0.0, (double)((float)this.right / 32.0f), (double)((float)(this.bottom + (int)this.getScrollAmount()) / 32.0f));
        tessellator.addVertexWithUV((double)this.right, (double)this.top, 0.0, (double)((float)this.right / 32.0f), (double)((float)(this.top + (int)this.getScrollAmount()) / 32.0f));
        tessellator.addVertexWithUV((double)this.left, (double)this.top, 0.0, (double)((float)this.left / 32.0f), (double)((float)(this.top + (int)this.getScrollAmount()) / 32.0f));
        tessellator.draw();
        int rowLeft = this.getRowLeft();
        int baseRowTop = this.top + 4 - (int)this.getScrollAmount();
        if (this.shouldRenderHeader) {
            this.renderHeader(rowLeft, baseRowTop, tessellator);
        }
        this.renderList(rowLeft, baseRowTop, mouseX, mouseY, delta);
        GL11.glDisable((int)2929);
        this.renderHoleBackground(0, this.top, 255, 255);
        this.renderHoleBackground(this.bottom, this.height, 255, 255);
        GL11.glEnable((int)3042);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)0, (int)1);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3553);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA(0, 0, 0, 0);
        tessellator.addVertexWithUV((double)this.left, (double)this.top + 4.0, 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV((double)this.right, (double)this.top + 4.0, 0.0, 1.0, 1.0);
        tessellator.setColorOpaque(0, 0, 0);
        tessellator.addVertexWithUV((double)this.right, (double)this.top, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV((double)this.left, (double)this.top, 0.0, 0.0, 0.0);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque(0, 0, 0);
        tessellator.addVertexWithUV((double)this.left, (double)this.bottom, 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV((double)this.right, (double)this.bottom, 0.0, 1.0, 1.0);
        tessellator.setColorRGBA(0, 0, 0, 0);
        tessellator.addVertexWithUV((double)this.right, (double)this.bottom - 4.0, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV((double)this.left, (double)this.bottom - 4.0, 0.0, 0.0, 0.0);
        tessellator.draw();
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            int visibleHeight = this.bottom - this.top;
            int contentHeight = this.getMaxPosition();
            int thumbHeight = (int)((float)visibleHeight * (float)visibleHeight / (float)contentHeight);
            if (thumbHeight < 32) {
                thumbHeight = 32;
            } else if (thumbHeight > visibleHeight - 8) {
                thumbHeight = visibleHeight - 8;
            }
            int thumbY = (int)this.getScrollAmount() * (visibleHeight - thumbHeight) / maxScroll + this.top;
            if (thumbY < this.top) {
                thumbY = this.top;
            }
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque(0, 0, 0);
            tessellator.addVertexWithUV((double)scrollbarX, (double)this.bottom, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV((double)scrollbarEndX, (double)this.bottom, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV((double)scrollbarEndX, (double)this.top, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV((double)scrollbarX, (double)this.top, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque(128, 128, 128);
            tessellator.addVertexWithUV((double)scrollbarX, (double)thumbY + (double)thumbHeight, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV((double)scrollbarEndX, (double)thumbY + (double)thumbHeight, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV((double)scrollbarEndX, (double)thumbY, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV((double)scrollbarX, (double)thumbY, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque(192, 192, 192);
            tessellator.addVertexWithUV((double)scrollbarX, (double)(thumbY + thumbHeight) - 1.0, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV((double)scrollbarEndX - 1.0, (double)(thumbY + thumbHeight) - 1.0, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV((double)scrollbarEndX - 1.0, (double)thumbY, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV((double)scrollbarX, (double)thumbY, 0.0, 0.0, 0.0);
            tessellator.draw();
        }
        this.renderDecorations(mouseX, mouseY);
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
    }

    protected void centerScrollOn(E entry) {
        int index = this.children().indexOf(entry);
        if (index < 0) {
            return;
        }
        int listHeight = this.bottom - this.top;
        int entryTop = this.getRowTop(index);
        int entryCenter = entryTop + this.itemHeight / 2;
        double newScroll = (double)entryCenter - (double)listHeight / 2.0;
        this.setScrollAmount(newScroll);
    }

    protected void ensureVisible(E entry) {
        int overshootBelow;
        int rowIndex = this.children().indexOf(entry);
        if (rowIndex < 0) {
            return;
        }
        int rowTop = this.getRowTop(rowIndex);
        int overshootAbove = rowTop - this.top - 4 - this.itemHeight;
        if (overshootAbove < 0) {
            this.applyScrollDelta(overshootAbove);
        }
        if ((overshootBelow = this.bottom - rowTop - this.itemHeight - this.itemHeight) < 0) {
            this.applyScrollDelta(-overshootBelow);
        }
    }

    private void applyScrollDelta(double deltaY) {
        if (deltaY == 0.0) {
            return;
        }
        this.setScrollAmount(this.getScrollAmount() + deltaY);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double value) {
        this.scrollAmount = MathHelper.clamp((double)value, (double)0.0, (double)this.getMaxScroll());
    }

    private int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4));
    }

    protected int getScrollbarPosition() {
        int halfList = this.getRowWidth() / 2;
        int centerX = this.left + this.width / 2;
        return centerX + halfList;
    }

    public void mouseClicked(int mouseX, int mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return;
        }
        E clickedEntry = this.getEntryAtPosition(mouseX, mouseY);
        if (clickedEntry != null) {
            if (this.focused == null || this.focused != clickedEntry) {
                this.focused = clickedEntry;
                this.selected = clickedEntry;
                super.mouseClicked(mouseX, mouseY, button);
            }
        } else if (button == 0) {
            int headerClickX = (int)((double)mouseX - ((double)this.left + (double)this.width / 2.0 - (double)this.getRowWidth() / 2.0));
            int headerClickY = (int)((double)mouseY - (double)this.top) + (int)this.getScrollAmount() - 4;
            this.onHeaderClicked(headerClickX, headerClickY);
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        E theFocused = this.getFocused();
        if (theFocused != null) {
            return ((Entry)((Object)theFocused)).mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double deltaX, double deltaY) {
        if (mouseButton == 0 && this.isMouseOver(mouseX, mouseY)) {
            int maxScroll = this.getMaxScroll();
            if (maxScroll <= 0) {
                return false;
            }
            int visibleHeight = this.bottom - this.top;
            int contentHeight = this.getMaxPosition();
            int thumbHeight = (int)((float)visibleHeight * (float)visibleHeight / (float)contentHeight);
            if (thumbHeight < 32) {
                thumbHeight = 32;
            } else if (thumbHeight > visibleHeight - 8) {
                thumbHeight = visibleHeight - 8;
            }
            int scrollTrack = visibleHeight - thumbHeight;
            if (scrollTrack <= 0) {
                return false;
            }
            double scrollChange = deltaY * (double)maxScroll / (double)scrollTrack;
            this.setScrollAmount(this.getScrollAmount() + scrollChange);
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        double amount = scrollDelta / -0.05;
        this.setScrollAmount(this.getScrollAmount() + amount);
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        E theFocused = this.getFocused();
        if (theFocused != null && ((Entry)((Object)theFocused)).keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 264) {
            this.moveSelection(1);
            return true;
        }
        if (keyCode == 265) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int direction) {
        if (!this.children().isEmpty()) {
            int currentIndex = this.children().indexOf(this.getSelected());
            int newIndex = MathHelper.clamp((int)(currentIndex + direction), (int)0, (int)(this.getItemCount() - 1));
            Entry entry = (Entry)((Object)this.children().get(newIndex));
            this.setSelected(entry);
            this.ensureVisible(entry);
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseY >= (double)this.top && mouseY <= (double)this.bottom && mouseX >= (double)this.left && mouseX <= (double)this.right;
    }

    protected void renderList(int rowLeft, int baseRowTop, int mouseX, int mouseY, float delta) {
        int itemCount = this.getItemCount();
        Tessellator tessellator = Tessellator.instance;
        for (int rowIndex = 0; rowIndex < itemCount; ++rowIndex) {
            int rowTop = this.getRowTop(rowIndex);
            int rowBottom = this.getRowBottom(rowIndex);
            if (rowBottom < this.top || rowTop > this.bottom) continue;
            int entryTop = baseRowTop + rowIndex * this.itemHeight + this.headerHeight;
            int rowHeightInner = this.itemHeight - 4;
            E entry = this.getEntry(rowIndex);
            int rowWidth = this.getRowWidth();
            if (this.renderSelection && this.isSelectedItem(rowIndex)) {
                int selectionLeft = this.left + this.width / 2 - rowWidth / 2;
                int selectionRight = this.left + this.width / 2 + rowWidth / 2;
                GL11.glDisable((int)3553);
                float selectionBrightness = this.isFocused() ? 1.0f : 0.5f;
                GL11.glColor4f((float)selectionBrightness, (float)selectionBrightness, (float)selectionBrightness, (float)1.0f);
                tessellator.startDrawingQuads();
                tessellator.addVertex((double)selectionLeft, (double)(entryTop + rowHeightInner) + 2.0, 0.0);
                tessellator.addVertex((double)selectionRight, (double)(entryTop + rowHeightInner) + 2.0, 0.0);
                tessellator.addVertex((double)selectionRight, (double)entryTop - 2.0, 0.0);
                tessellator.addVertex((double)selectionLeft, (double)entryTop - 2.0, 0.0);
                tessellator.draw();
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                tessellator.startDrawingQuads();
                tessellator.addVertex((double)selectionLeft + 1.0, (double)(entryTop + rowHeightInner) + 1.0, 0.0);
                tessellator.addVertex((double)selectionRight - 1.0, (double)(entryTop + rowHeightInner) + 1.0, 0.0);
                tessellator.addVertex((double)selectionRight - 1.0, (double)entryTop - 1.0, 0.0);
                tessellator.addVertex((double)selectionLeft + 1.0, (double)entryTop - 1.0, 0.0);
                tessellator.draw();
                GL11.glEnable((int)3553);
            }
            int entryLeft = this.getRowLeft();
            boolean hovered = this.isMouseOver(mouseX, mouseY) && Objects.equals(this.getEntryAtPosition(mouseX, mouseY), entry);
            ((Entry)((Object)entry)).render(rowIndex, rowTop, entryLeft, rowWidth, rowHeightInner, mouseX, mouseY, hovered, delta);
        }
    }

    protected int getRowLeft() {
        return this.left + this.width / 2 - this.getRowWidth() / 2 + 2;
    }

    protected int getRowTop(int rowIndex) {
        return this.top + 4 - (int)this.getScrollAmount() + rowIndex * this.itemHeight + this.headerHeight;
    }

    int getRowBottom(int rowIndex) {
        return this.getRowTop(rowIndex) + this.itemHeight;
    }

    protected boolean isFocused() {
        return false;
    }

    protected void renderHoleBackground(int topY, int bottomY, int topAlpha, int bottomAlpha) {
        Tessellator tessellator = Tessellator.instance;
        this.minecraft.textureManager.bindTexture(this.minecraft.textureManager.loadTexture("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA(64, 64, 64, bottomAlpha);
        tessellator.addVertexWithUV((double)this.left, (double)bottomY, 0.0, 0.0, (double)((float)bottomY / 32.0f));
        tessellator.addVertexWithUV((double)this.left + (double)this.width, (double)bottomY, 0.0, (double)((float)this.width / 32.0f), (double)((float)bottomY / 32.0f));
        tessellator.setColorRGBA(64, 64, 64, topAlpha);
        tessellator.addVertexWithUV((double)this.left + (double)this.width, (double)topY, 0.0, (double)((float)this.width / 32.0f), (double)((float)topY / 32.0f));
        tessellator.addVertexWithUV((double)this.left, (double)topY, 0.0, 0.0, (double)((float)topY / 32.0f));
        tessellator.draw();
    }

    protected E remove(int index) {
        Entry entry = (Entry)((Object)this.children.get(index));
        return (E)((Object)(this.removeEntry((E)((Object)entry)) ? entry : null));
    }

    protected boolean removeEntry(E entry) {
        boolean removed = this.children.remove(entry);
        if (removed && entry == this.getSelected()) {
            this.setSelected(null);
        }
        return removed;
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry<E extends Entry<E>>
    extends Screen {
        protected Entry() {
        }

        public abstract void render(int var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

        public void mouseMoved(double mouseX, double mouseY) {
        }

        public void mouseClicked(int mouseX, int mouseY, int button) {
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            return false;
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollAmount) {
            return false;
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            return false;
        }

        public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
            return false;
        }

        public boolean charTyped(char character, int keyCode) {
            return false;
        }

        public boolean changeFocus(boolean moveForward) {
            return false;
        }
    }

    @Environment(value=EnvType.CLIENT)
    class EntryList
    extends AbstractList<E> {
        private final List<E> entries = Lists.newArrayList();

        private EntryList() {
        }

        @Override
        public E get(int index) {
            return (Object)((Entry)((Object)this.entries.get(index)));
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        @Override
        public E set(int index, E entry) {
            return (Object)((Entry)((Object)this.entries.set(index, entry)));
        }

        @Override
        public void add(int index, E entry) {
            this.entries.add(index, entry);
        }

        @Override
        public E remove(int index) {
            return (Object)((Entry)((Object)this.entries.remove(index)));
        }
    }
}

