/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.gui;

import io.github.prospector.modmenu.ModMenu;
import io.github.prospector.modmenu.config.ModMenuConfigManager;
import io.github.prospector.modmenu.gui.AlwaysSelectedEntryListWidget;
import io.github.prospector.modmenu.gui.ModListEntry;
import io.github.prospector.modmenu.gui.ModListScreen;
import io.github.prospector.modmenu.gui.entries.ChildEntry;
import io.github.prospector.modmenu.gui.entries.IndependentEntry;
import io.github.prospector.modmenu.gui.entries.ParentEntry;
import io.github.prospector.modmenu.util.ModListSearch;
import io.github.prospector.modmenu.util.TestModContainer;
import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class ModListWidget
extends AlwaysSelectedEntryListWidget<ModListEntry>
implements AutoCloseable {
    public static final boolean DEBUG = Boolean.getBoolean("modmenu.debug");
    private final Map<Path, BufferedImage> modIconsCache = new HashMap<Path, BufferedImage>();
    private final ModListScreen parent;
    private List<ModContainer> modContainerList = null;
    private final Set<ModContainer> addedMods = new HashSet<ModContainer>();
    private String selectedModId = null;

    public ModListWidget(Minecraft client, int width, int height, int top, int bottom, int entryHeight, String searchTerm, ModListWidget previousList, ModListScreen parent) {
        super(client, width, height, top, bottom, entryHeight);
        this.parent = parent;
        if (previousList != null) {
            this.modContainerList = previousList.modContainerList;
        }
        this.filter(searchTerm, false);
        int maxScrollRange = Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4));
        this.setScrollAmount(parent.getScrollPercent() * (double)maxScrollRange);
    }

    @Override
    public void setScrollAmount(double amount) {
        super.setScrollAmount(amount);
        int maxScrollRange = Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4));
        if (maxScrollRange == 0) {
            this.parent.updateScrollPercent(0.0);
        } else {
            this.parent.updateScrollPercent(this.getScrollAmount() / (double)maxScrollRange);
        }
    }

    public void select(ModListEntry entry) {
        this.setSelected(entry);
    }

    @Override
    public void setSelected(ModListEntry entry) {
        super.setSelected(entry);
        this.selectedModId = entry.getMetadata().getId();
        this.parent.updateSelectedEntry((ModListEntry)((Object)this.getSelected()));
    }

    @Override
    protected boolean isSelectedItem(int index) {
        ModListEntry selected = (ModListEntry)((Object)this.getSelected());
        if (selected == null) {
            return false;
        }
        return selected.getMetadata().getId().equals(((ModListEntry)((Object)this.getEntry(index))).getMetadata().getId());
    }

    @Override
    public int addEntry(ModListEntry entry) {
        if (this.addedMods.contains(entry.container)) {
            return 0;
        }
        this.addedMods.add(entry.container);
        int idx = super.addEntry(entry);
        if (entry.getMetadata().getId().equals(this.selectedModId)) {
            this.setSelected(entry);
        }
        return idx;
    }

    @Override
    protected boolean removeEntry(ModListEntry entry) {
        this.addedMods.remove(entry.container);
        return super.removeEntry(entry);
    }

    @Override
    protected ModListEntry remove(int index) {
        this.addedMods.remove(((ModListEntry)((Object)this.getEntry((int)index))).container);
        return (ModListEntry)((Object)super.remove(index));
    }

    public void reloadFilters() {
        this.filter(this.parent.getSearchInput(), true);
    }

    public void filter(String searchTerm, boolean refresh) {
        this.clearEntries();
        this.addedMods.clear();
        ArrayList<ModContainer> mods = FabricLoader.getInstance().getAllMods();
        if (DEBUG) {
            mods = new ArrayList<ModContainer>(mods);
            mods.addAll(TestModContainer.getTestModContainers());
        }
        if (this.modContainerList == null || refresh) {
            this.modContainerList = new ArrayList<ModContainer>();
            this.modContainerList.addAll(mods);
            this.modContainerList.sort(ModMenuConfigManager.getConfig().getSorting().getComparator());
        }
        List<ModContainer> matched = ModListSearch.search(this.parent, searchTerm, this.modContainerList);
        for (ModContainer modContainer : matched) {
            ModMetadata metadata = modContainer.getMetadata();
            String modId = metadata.getId();
            boolean library = ModMenu.LIBRARY_MODS.contains(modId);
            if (library && !ModMenuConfigManager.getConfig().showLibraries() || ModMenu.PARENT_MAP.values().contains(modContainer)) continue;
            if (ModMenu.PARENT_MAP.keySet().contains(modContainer)) {
                List children = ModMenu.PARENT_MAP.get((Object)modContainer);
                children.sort(ModMenuConfigManager.getConfig().getSorting().getComparator());
                ParentEntry parentEntry = new ParentEntry(this.minecraft, modContainer, children, this);
                this.addEntry(parentEntry);
                if (!this.parent.getShowModChildren().contains(modId)) continue;
                List<ModContainer> validChildren = ModListSearch.search(this.parent, searchTerm, children);
                for (ModContainer child : validChildren) {
                    boolean lastChild = validChildren.indexOf(child) == validChildren.size() - 1;
                    this.addEntry(new ChildEntry(this.minecraft, child, this, lastChild));
                }
                continue;
            }
            this.addEntry(new IndependentEntry(this.minecraft, modContainer, this));
        }
        ModListEntry theSelected = (ModListEntry)((Object)this.getSelected());
        if (this.parent.getSelectedEntry() != null && !this.children().isEmpty() || theSelected != null && theSelected.getMetadata() != this.parent.getSelectedEntry().getMetadata()) {
            for (ModListEntry entry : this.children()) {
                if (!entry.getMetadata().equals(this.parent.getSelectedEntry().getMetadata())) continue;
                this.setSelected(entry);
            }
        } else if (this.getSelected() == null && !this.children().isEmpty() && this.getEntry(0) != null) {
            this.setSelected((ModListEntry)((Object)this.getEntry(0)));
        }
        int n = Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4));
        if (this.getScrollAmount() > (double)n) {
            this.setScrollAmount(n);
        }
    }

    @Override
    protected void renderList(int rowLeft, int baseRowTop, int mouseX, int mouseY, float delta) {
        int itemCount = this.getItemCount();
        Tessellator tessellator = Tessellator.instance;
        for (int index = 0; index < itemCount; ++index) {
            int rowTop = this.getRowTop(index);
            int rowBottom = this.getRowBottom(index);
            if (rowBottom < this.top || rowTop > this.bottom) continue;
            ModListEntry entry = (ModListEntry)((Object)this.getEntry(index));
            int entryTop = rowTop + 2;
            int rowHeightInner = this.itemHeight - 4;
            int rowWidth = this.getRowWidth();
            if (this.renderSelection && this.isSelectedItem(index)) {
                int selectionLeft = this.getRowLeft() - 2 + entry.getXOffset();
                int selectionRight = rowLeft + rowWidth + 2;
                GL11.glDisable((int)3553);
                float brightness = this.isFocused() ? 1.0f : 0.5f;
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
                tessellator.startDrawingQuads();
                tessellator.addVertex((double)selectionLeft, (double)(entryTop + rowHeightInner) + 2.0, 0.0);
                tessellator.addVertex((double)selectionRight, (double)(entryTop + rowHeightInner) + 2.0, 0.0);
                tessellator.addVertex((double)selectionRight, (double)entryTop - 2.0, 0.0);
                tessellator.addVertex((double)selectionLeft, (double)entryTop - 2.0, 0.0);
                tessellator.draw();
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                tessellator.startDrawingQuads();
                tessellator.addVertex((double)selectionLeft + 1.0, (double)(entryTop + rowHeightInner) + 1.0, 0.0);
                tessellator.addVertex((double)selectionRight - 1.0, (double)(entryTop + rowHeightInner) + 1.0, 0.0);
                tessellator.addVertex((double)selectionRight - 1.0, (double)entryTop - 1.0, 0.0);
                tessellator.addVertex((double)selectionLeft + 1.0, (double)entryTop - 1.0, 0.0);
                tessellator.draw();
                GL11.glEnable((int)3553);
            }
            int entryLeft = this.getRowLeft();
            boolean hovered = this.isMouseOver(mouseX, mouseY) && Objects.equals((Object)this.getEntryAtPosition(mouseX, mouseY), (Object)entry);
            entry.render(index, entryTop, entryLeft, rowWidth, rowHeightInner, mouseX, mouseY, hovered, delta);
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return;
        }
        ModListEntry clickedEntry = this.getEntryAtPosition(mouseX, mouseY);
        if (clickedEntry != null) {
            if (this.getFocused() != clickedEntry) {
                this.setFocused(clickedEntry);
            }
            this.setSelected(clickedEntry);
            clickedEntry.mouseClicked(mouseX, mouseY, button);
        } else if (button == 0) {
            int headerClickX = (int)((double)mouseX - ((double)this.left + (double)this.width / 2.0 - (double)this.getRowWidth() / 2.0));
            int headerClickY = (int)((double)mouseY - (double)this.top) + (int)this.getScrollAmount() - 4;
            this.onHeaderClicked(headerClickX, headerClickY);
        }
    }

    @Override
    protected ModListEntry getEntryAtPosition(double mouseX, double mouseY) {
        int yInList = MathHelper.floor((double)(mouseY - (double)this.top)) - this.headerHeight + (int)this.getScrollAmount() - 4;
        int rowIndex = yInList / this.itemHeight;
        int rowLeft = this.getRowLeft();
        int rowRight = rowLeft + this.getRowWidth();
        if (mouseX >= (double)this.getScrollbarPosition() || mouseX < (double)rowLeft || mouseX > (double)rowRight) {
            return null;
        }
        if (yInList < 0 || rowIndex < 0 || rowIndex >= this.getItemCount()) {
            return null;
        }
        return (ModListEntry)((Object)this.children().get(rowIndex));
    }

    @Override
    protected int getScrollbarPosition() {
        return this.width - 6;
    }

    @Override
    public int getRowWidth() {
        int scrollRange = Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4));
        return this.width - (scrollRange > 0 ? 18 : 12);
    }

    @Override
    protected int getRowLeft() {
        return this.left + 6;
    }

    public int getWidth() {
        return this.width;
    }

    public int getTop() {
        return this.top;
    }

    public ModListScreen getParent() {
        return this.parent;
    }

    @Override
    protected int getMaxPosition() {
        return super.getMaxPosition() + 4;
    }

    public int getDisplayedCount() {
        return this.children().size();
    }

    @Override
    public void close() {
        this.children().forEach(ModListEntry::deleteTexture);
    }

    BufferedImage getCachedModIcon(Path path) {
        return this.modIconsCache.get(path);
    }

    void cacheModIcon(Path path, BufferedImage texture) {
        this.modIconsCache.put(path, texture);
    }

    public Set<ModContainer> getCurrentModSet() {
        return this.addedMods;
    }
}

