/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.gui.entries;

import io.github.prospector.modmenu.gui.ModListEntry;
import io.github.prospector.modmenu.gui.ModListWidget;
import io.github.prospector.modmenu.util.ModListSearch;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.tessellator.Tessellator;
import org.lwjgl.opengl.GL11;

public class ParentEntry
extends ModListEntry {
    private static final String PARENT_MOD_TEXTURE = "/assets/modmenu/textures/gui/parent_mod.png";
    protected List<ModContainer> children;
    protected boolean hoveringIcon = false;

    public ParentEntry(Minecraft client, ModContainer parent, List<ModContainer> children, ModListWidget list) {
        super(client, parent, list);
        this.children = children;
    }

    @Override
    public void render(int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float delta) {
        super.render(index, rowTop, rowLeft, rowWidth, rowHeight, mouseX, mouseY, hovered, delta);
        Font font = this.client.font;
        int childrenBadgeHeight = 9;
        int childrenBadgeWidth = 9;
        int childrenCount = ModListSearch.search(this.list.getParent(), this.list.getParent().getSearchInput(), this.getChildren()).size();
        int childrenTextWidth = font.getStringWidth(Integer.toString(childrenCount)) - 1;
        if (childrenBadgeWidth < childrenTextWidth + 4) {
            childrenBadgeWidth = childrenTextWidth + 4;
        }
        int childrenBadgeX = rowLeft + 32 - childrenBadgeWidth;
        int childrenBadgeY = rowTop + 32 - childrenBadgeHeight;
        int outlineColor = -2012163944;
        int fillColor = -2012978874;
        this.drawRect(childrenBadgeX + 1, childrenBadgeY, childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + 1, outlineColor);
        this.drawRect(childrenBadgeX, childrenBadgeY + 1, childrenBadgeX + 1, childrenBadgeY + childrenBadgeHeight - 1, outlineColor);
        this.drawRect(childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + 1, childrenBadgeX + childrenBadgeWidth, childrenBadgeY + childrenBadgeHeight - 1, outlineColor);
        this.drawRect(childrenBadgeX + 1, childrenBadgeY + childrenBadgeHeight - 1, childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + childrenBadgeHeight, outlineColor);
        this.drawRect(childrenBadgeX + 1, childrenBadgeY + 1, childrenBadgeX + childrenBadgeWidth - 1, childrenBadgeY + childrenBadgeHeight - 1, fillColor);
        font.drawString(Integer.toString(childrenCount), childrenBadgeX + childrenBadgeWidth / 2 - childrenTextWidth / 2, childrenBadgeY + 1, 0xCACACA);
        boolean bl = this.hoveringIcon = mouseX >= rowLeft - 1 && mouseX <= rowLeft - 1 + 32 && mouseY >= rowTop - 1 && mouseY <= rowTop - 1 + 32;
        if (hovered) {
            this.drawRect(rowLeft, rowTop, rowLeft + 32, rowTop + 32, -1601138544);
            this.client.textureManager.bindTexture(this.client.textureManager.loadTexture(PARENT_MOD_TEXTURE));
            boolean childrenVisible = this.list.getParent().getShowModChildren().contains(this.getMetadata().getId());
            int xOffset = childrenVisible ? 32 : 0;
            int yOffset = this.hoveringIcon ? 32 : 0;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tess = Tessellator.instance;
            tess.startDrawingQuads();
            tess.addVertexWithUV((double)rowLeft, (double)rowTop, 0.0, (double)((float)xOffset / 256.0f), (double)((float)yOffset / 256.0f));
            tess.addVertexWithUV((double)rowLeft, (double)rowTop + 32.0, 0.0, (double)((float)xOffset / 256.0f), (double)((float)(yOffset + 32) / 256.0f));
            tess.addVertexWithUV((double)rowLeft + 32.0, (double)rowTop + 32.0, 0.0, (double)((float)(xOffset + 32) / 256.0f), (double)((float)(yOffset + 32) / 256.0f));
            tess.addVertexWithUV((double)rowLeft + 32.0, (double)rowTop, 0.0, (double)((float)(xOffset + 32) / 256.0f), (double)((float)yOffset / 256.0f));
            tess.draw();
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button) {
        if (this.hoveringIcon) {
            String id = this.getMetadata().getId();
            if (this.list.getParent().getShowModChildren().contains(id)) {
                this.list.getParent().getShowModChildren().remove(id);
            } else {
                this.list.getParent().getShowModChildren().add(id);
            }
            this.list.filter(this.list.getParent().getSearchInput(), false);
        }
        super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            String id = this.getMetadata().getId();
            if (this.list.getParent().getShowModChildren().contains(id)) {
                this.list.getParent().getShowModChildren().remove(id);
            } else {
                this.list.getParent().getShowModChildren().add(id);
            }
            this.list.filter(this.list.getParent().getSearchInput(), false);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void setChildren(List<ModContainer> children) {
        this.children = children;
    }

    public void addChildren(List<ModContainer> children) {
        this.children.addAll(children);
    }

    public void addChildren(ModContainer ... children) {
        this.children.addAll(Arrays.asList(children));
    }

    public List<ModContainer> getChildren() {
        return this.children;
    }
}

