/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper.recipeBuilders;

import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingShaped;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.ItemStack;
import turniplabs.halplibe.helper.RecipeBuilder;
import turniplabs.halplibe.helper.recipeBuilders.RecipeBuilderBase;

public class RecipeBuilderShaped
extends RecipeBuilderBase {
    protected String[] shape;
    protected int width;
    protected int height;
    protected boolean consumeContainer = false;
    protected final HashMap<Character, RecipeSymbol> symbolShapedMap = new HashMap();

    public RecipeBuilderShaped(String modID) {
        super(modID);
    }

    public RecipeBuilderShaped(String modID, String ... shape) {
        super(modID);
        this.setShapeLocal(shape);
    }

    public RecipeBuilderShaped setShape(String ... shapeTemplate) {
        RecipeBuilderShaped builder = this.clone(this);
        builder.setShapeLocal(shapeTemplate);
        return builder;
    }

    protected void setShapeLocal(String ... shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Shape Template cannot be set to null!");
        }
        if (shape.length == 0) {
            throw new IllegalArgumentException("Shape Template cannot have a size of 0!");
        }
        if (shape.length > 3) {
            throw new IllegalArgumentException("Shape Template height cannot exceed 3!\n" + Arrays.toString(shape));
        }
        if (shape[0].length() > 3) {
            throw new IllegalArgumentException("Shape Template width cannot exceed 3!\n" + Arrays.toString(shape));
        }
        this.height = shape.length;
        this.width = shape[0].length();
        for (int y = 0; y < this.height; ++y) {
            this.width = Math.max(this.width, shape[y].length());
        }
        String[] internalShape = new String[this.height];
        for (int y = 0; y < internalShape.length; ++y) {
            StringBuilder builder = new StringBuilder();
            String row = shape[y];
            for (int x = 0; x < this.width; ++x) {
                if (x >= row.length()) {
                    builder.append(" ");
                    continue;
                }
                builder.append(row.charAt(x));
            }
            internalShape[y] = builder.toString();
        }
        this.shape = internalShape;
    }

    public RecipeBuilderShaped setConsumeContainer(boolean consumeContainer) {
        RecipeBuilderShaped builder = this.clone(this);
        builder.consumeContainer = consumeContainer;
        return builder;
    }

    public RecipeBuilderShaped addInput(char templateSymbol, IItemConvertible stack) {
        return this.addInput(templateSymbol, stack, 0);
    }

    public RecipeBuilderShaped addInput(char templateSymbol, IItemConvertible stack, int meta) {
        ItemStack _stack = stack.getDefaultStack();
        _stack.setMetadata(meta);
        return this.addInput(templateSymbol, _stack);
    }

    public RecipeBuilderShaped addInput(char templateSymbol, ItemStack stack) {
        return this.addInput(templateSymbol, new RecipeSymbol(stack));
    }

    public RecipeBuilderShaped addInput(char templateSymbol, String itemGroup) {
        return this.addInput(templateSymbol, new RecipeSymbol(itemGroup));
    }

    public RecipeBuilderShaped addInput(char templateSymbol, RecipeSymbol symbol) {
        if (templateSymbol == ' ') {
            throw new IllegalArgumentException("Cannot assign item to protected symbol ' ' pick a different symbol for your recipe input");
        }
        RecipeBuilderShaped builder = this.clone(this);
        this.symbolShapedMap.put(Character.valueOf(templateSymbol), symbol);
        return builder;
    }

    @Override
    public void create(String recipeID, ItemStack outputStack) {
        if (this.shape == null) {
            throw new RuntimeException("Shaped recipe: " + recipeID + " attempted to build without a assigned shape!!");
        }
        RecipeSymbol[] recipe = new RecipeSymbol[this.height * this.width];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                RecipeSymbol s;
                RecipeSymbol tempplate;
                Character cha = null;
                if (this.shape[y].length() > x) {
                    cha = Character.valueOf(this.shape[y].charAt(x));
                }
                recipe[x + y * this.width] = (tempplate = this.symbolShapedMap.get(cha)) == null ? null : (tempplate.getItemGroup() == null ? (s = new RecipeSymbol(cha == null ? (char)' ' : (char)cha.charValue(), tempplate.getStack())) : new RecipeSymbol(cha == null ? (char)' ' : (char)cha.charValue(), tempplate.getStack(), tempplate.getItemGroup()));
            }
        }
        RecipeBuilder.getRecipeGroup(this.modID, "workbench", new RecipeSymbol(Blocks.WORKBENCH.getDefaultStack())).register(recipeID, (RecipeEntryBase)new RecipeEntryCraftingShaped(this.width, this.height, recipe, outputStack, this.consumeContainer));
    }
}

