/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.util;

import java.util.LinkedHashMap;
import net.minecraft.core.item.ItemStack;
import org.jspecify.annotations.NonNull;

public class CreativeEntry
implements Comparable<CreativeEntry> {
    public static final LinkedHashMap<String, CreativeEntry> priorityEntryMap = new LinkedHashMap();
    public static final LinkedHashMap<String, CreativeEntry> childEntryMap = new LinkedHashMap();
    public int priority;
    public final ItemStack stackToAdd;
    public ItemStack parentStack;

    public static void addEntry(CreativeEntry entry) {
        String key = entry.stackToAdd.toString();
        if (entry.parentStack != null) {
            childEntryMap.put(key, entry);
            priorityEntryMap.remove(key);
        } else {
            priorityEntryMap.put(key, entry);
            childEntryMap.remove(key);
        }
    }

    public CreativeEntry(ItemStack stack) {
        this(stack, 1000);
    }

    public CreativeEntry(ItemStack stack, int priority) {
        this.stackToAdd = stack.copy();
        this.stackToAdd.stackSize = 1;
        this.priority = priority;
    }

    public CreativeEntry(ItemStack stackToAdd, ItemStack parentStack) {
        this.stackToAdd = stackToAdd.copy();
        this.stackToAdd.stackSize = 1;
        this.parentStack = parentStack.copy();
        this.parentStack.stackSize = 1;
    }

    @Override
    public int compareTo(@NonNull CreativeEntry o) {
        return this.priority - o.priority;
    }
}

