/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.util.toml;

import turniplabs.halplibe.util.toml.Entry;
import turniplabs.halplibe.util.toml.Toml;

public class TomlParser {
    public static Toml parse(String src) {
        Toml toml1 = new Toml();
        String cat = "";
        for (String s : src.split("\n")) {
            if ((s = s.trim()).startsWith("[") && s.endsWith("]")) {
                while (s.startsWith("[") && s.endsWith("]")) {
                    cat = s = s.substring(1, s.length() - 1);
                }
                cat = cat.trim();
                continue;
            }
            if (s.startsWith("#") || s.isEmpty()) continue;
            String[] split = s.split("=", 2);
            String key = cat + (cat.isEmpty() ? "" : ".") + split[0].trim();
            String value = split[1].trim();
            if (value.startsWith("\"")) {
                toml1.addEntry(key, new Entry<String>(value.substring(1, value.length() - 1)));
                continue;
            }
            if (value.contains(".")) {
                toml1.addEntry(key, new Entry<Double>(Double.parseDouble(value)));
                continue;
            }
            if (value.equals("true")) {
                toml1.addEntry(key, new Entry<Boolean>(true));
                continue;
            }
            if (value.equals("false")) {
                toml1.addEntry(key, new Entry<Boolean>(false));
                continue;
            }
            try {
                toml1.addEntry(key, new Entry<Integer>(Integer.parseInt(value)));
            }
            catch (Throwable err) {
                try {
                    toml1.addEntry(key, new Entry<Double>(Double.parseDouble(value)));
                }
                catch (Throwable ignored1) {
                    toml1.addEntry(key, new Entry<String>(value));
                }
            }
        }
        return toml1;
    }
}

