/*
 * Decompiled with CFR 0.152.
 */
package rootenginear.leavesalwaysfalling.mixin;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.Option;
import net.minecraft.client.option.OptionFloat;
import net.minecraft.client.option.OptionRange;
import net.minecraft.core.lang.I18n;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import rootenginear.leavesalwaysfalling.interfaces.ILeavesSettings;
import rootenginear.leavesalwaysfalling.utils.Utils;

@Environment(value=EnvType.CLIENT)
@Mixin(value={GameSettings.class}, remap=false)
public class GameSettingsMixin
implements ILeavesSettings {
    @Unique
    private final GameSettings self = (GameSettings)this;
    @Unique
    private final OptionRange frequency = new OptionRange(this.self, "leavesalwaysfalling.frequency", 3, 0, 100);
    @Unique
    private final OptionFloat gravityMultiplier = new OptionFloat(this.self, "leavesalwaysfalling.gravityMultiplier", 0.09f);
    @Unique
    private final OptionFloat xMultiplier = new OptionFloat(this.self, "leavesalwaysfalling.xMultiplier", 0.09f);
    @Unique
    private final OptionFloat zMultiplier = new OptionFloat(this.self, "leavesalwaysfalling.zMultiplier", 0.09f);

    @Inject(method={"getDisplayString"}, at={@At(value="HEAD")}, cancellable=true)
    private void customDisplayString(Option<?> option, CallbackInfoReturnable<String> cir) {
        if (option == this.frequency) {
            int value = (Integer)option.value;
            if (value == 0) {
                cir.setReturnValue((Object)I18n.getInstance().translateKey("options.leavesalwaysfalling.frequency.never"));
                return;
            }
            if (value == 100) {
                cir.setReturnValue((Object)I18n.getInstance().translateKey("options.leavesalwaysfalling.frequency.always"));
                return;
            }
            cir.setReturnValue((Object)(value + "%"));
        } else if (option == this.gravityMultiplier || option == this.xMultiplier || option == this.zMultiplier) {
            float value = ((Float)option.value).floatValue();
            float normalizedValue = Utils.normalizeGravityMultiplier(value);
            cir.setReturnValue((Object)(Utils.formatFloatOneDecimal(normalizedValue) + "x"));
        }
    }

    @Override
    public OptionRange bta_rootenginear_mods$getFrequencyOption() {
        return this.frequency;
    }

    @Override
    public OptionFloat bta_rootenginear_mods$getGravityMultiplierOption() {
        return this.gravityMultiplier;
    }

    @Override
    public OptionFloat bta_rootenginear_mods$getXMultiplierOption() {
        return this.xMultiplier;
    }

    @Override
    public OptionFloat bta_rootenginear_mods$getZMultiplierOption() {
        return this.zMultiplier;
    }
}

