/*
 * Decompiled with CFR 0.152.
 */
package bigsir.untitledshadermod.mixin;

import bigsir.untitledshadermod.UShaderMod;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.Option;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GameSettings.class}, remap=false)
public abstract class GameSettingsMixin {
    @Inject(method={"optionChanged"}, at={@At(value="HEAD")})
    public void reloadRenderers(Option<?> option, CallbackInfo ci) {
        if (option == UShaderMod.redBits || option == UShaderMod.greenBits || option == UShaderMod.blueBits) {
            UShaderMod.setupToneMap();
        } else if (option == UShaderMod.bayerMatrix) {
            UShaderMod.setupBayer();
        } else if (option == UShaderMod.bayerBrightness) {
            UShaderMod.bayerBrightnessCache = (float)((Integer)UShaderMod.bayerBrightness.value).intValue() / 100.0f;
        }
    }

    @Inject(method={"getDisplayString"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/lang/I18n;getInstance()Lnet/minecraft/core/lang/I18n;")}, cancellable=true)
    public void optionString(Option<?> option, CallbackInfoReturnable<String> cir) {
        if (option == UShaderMod.bayerMatrix) {
            int size = UShaderMod.bayerSizeCache;
            cir.setReturnValue((Object)(size + "x" + size));
        } else if (option == UShaderMod.ditherFalloff || option == UShaderMod.toneMapFalloff) {
            cir.setReturnValue((Object)UShaderMod.translateFrom(UShaderMod.FALLOFF_STRING, (Integer)option.value));
        } else if (option == UShaderMod.falloffType) {
            cir.setReturnValue((Object)UShaderMod.translateFrom(UShaderMod.FALLOFF_TYPE_STRING, (Integer)option.value));
        } else if (option == UShaderMod.pixelSize) {
            int value = (Integer)option.value;
            cir.setReturnValue((Object)(value <= 0 ? UShaderMod.translateKey("automatic") : String.valueOf((int)Math.pow(2.0, value - 1))));
        } else if (option == UShaderMod.bayerBrightness) {
            cir.setReturnValue((Object)((Integer)option.value + "%"));
        }
    }
}

