/*
 * Decompiled with CFR 0.152.
 */
package bigsir.untitledshadermod.utils;

import bigsir.untitledshadermod.UShaderMod;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL20;

public final class ShaderInject {
    private static final Map<String, BiFunction<String, String, String>> shaderToMutatorMap = new HashMap<String, BiFunction<String, String, String>>();

    private ShaderInject() {
    }

    public static void register(@NotNull String shaderName, BiFunction<String, String, String> mutator) {
        shaderToMutatorMap.put(shaderName, mutator);
    }

    @NotNull
    public static String mutateSource(@NotNull String name, @NotNull String source) {
        BiFunction<String, String, String> mutatorFunction = shaderToMutatorMap.get(name);
        if (mutatorFunction == null) {
            return source;
        }
        String mutatedString = mutatorFunction.apply(name, source);
        int shaderType = -1;
        if (name.startsWith("vertex/")) {
            shaderType = 35633;
        } else if (name.startsWith("fragment/")) {
            shaderType = 35632;
        }
        if (shaderType != -1) {
            int shader = GL20.glCreateShader((int)shaderType);
            GL20.glShaderSource((int)shader, (CharSequence)mutatedString);
            GL20.glCompileShader((int)shader);
            int vertexShaderCompileStatus = GL20.glGetShaderi((int)shader, (int)35713);
            if (vertexShaderCompileStatus != 1) {
                String info = GL20.glGetShaderInfoLog((int)shader);
                UShaderMod.LOGGER.error("Failed to compile mutated shader '{}', source is unaffected:\n{}", (Object)name, (Object)info);
                GL20.glDeleteShader((int)shader);
                return source;
            }
            GL20.glDeleteShader((int)shader);
        }
        return mutatedString;
    }
}

