/*
 * Decompiled with CFR 0.152.
 */
package bigsir.untitledshadermod.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class ShaderParser {
    public List<String> functions = new ArrayList<String>();
    public List<String> globals = new ArrayList<String>();

    public static String extractFunctionBody(@NotNull String function) {
        return function.substring(function.indexOf("{") + 1, function.lastIndexOf("}"));
    }

    public void findFunctions(@NotNull String source) {
        Pattern functionPattern = Pattern.compile("\\b(?!else)(\\S+)\\b\\s+\\b\\S+\\b\\s*\\(.*\\)\\s*[{]");
        Matcher matcher = functionPattern.matcher(source);
        StringBuilder noFuncBuilder = new StringBuilder();
        int lastClosing = 0;
        while (matcher.find()) {
            int end = matcher.end() - 1;
            int braces = 0;
            int globalStart = Math.min(source.length(), lastClosing + 1);
            int globalEnd = Math.max(0, matcher.start() - 1);
            if (globalEnd > globalStart) {
                noFuncBuilder.append(source, lastClosing == 0 ? 0 : globalStart, globalEnd);
            }
            lastClosing = end;
            for (int i = end; i < source.length(); ++i) {
                char c = source.charAt(i);
                if (c == '{') {
                    ++braces;
                } else if (c == '}') {
                    --braces;
                    lastClosing = i;
                }
                if (braces == 0) break;
            }
            this.functions.add(matcher.group() + source.substring(end + 1, lastClosing + 1));
        }
        for (String string : noFuncBuilder.toString().split("\n")) {
            if (StringUtils.isBlank((CharSequence)string)) continue;
            this.globals.add(string);
        }
    }
}

