/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.config;

import b100.minimap.Minimap;
import b100.minimap.config.Option;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;

public abstract class ConfigBase {
    public boolean read(File file) {
        if (!file.exists()) {
            return false;
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            this.read(stream);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(InputStream stream) {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        List<Option<?>> options = this.getAllOptions();
        HashMap optionMap = new HashMap();
        for (Option<?> option : options) {
            optionMap.put(option.name, option);
        }
        try {
            while (true) {
                String line;
                if ((line = br.readLine()) == null) {
                    return;
                }
                if (line.length() == 0 || line.startsWith("#")) continue;
                int i = line.indexOf(58);
                if (i == -1) {
                    Minimap.log("Invalid line: \"" + line + "\"");
                    continue;
                }
                String key = line.substring(0, i);
                String value = line.substring(i + 1);
                Option option = (Option)optionMap.get(key);
                if (option != null) {
                    try {
                        this.parse(option, value);
                    }
                    catch (Exception e) {
                        Minimap.log("Invalid value for option " + option.name + ": \"" + value + "\"");
                    }
                    continue;
                }
                Minimap.log("Invalid option: \"" + key + "\"");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    public void write(File file) {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            this.write(stream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
    }

    public void write(OutputStream stream) {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(stream);
            List<Option<?>> options = this.getAllOptions();
            for (Option<?> option : options) {
                writer.write(option.name + ":" + option.getValueString() + "\n");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private <E> void parse(Option<E> option, String value) {
        option.value = option.parse(value);
    }

    public abstract List<Option<?>> getAllOptions();
}

