/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.gui;

import b100.minimap.gui.ActionListener;
import b100.minimap.gui.CancelEventException;
import b100.minimap.gui.Colors;
import b100.minimap.gui.GuiElement;
import b100.minimap.gui.GuiScreen;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class GuiButton
extends GuiElement {
    public GuiScreen screen;
    public String text;
    public int icon = -1;
    public boolean clickable = true;
    public boolean mouseOver = false;
    public List<ActionListener> actionListeners = new ArrayList<ActionListener>();

    public GuiButton(GuiScreen screen, String text) {
        this(screen);
        this.setText(text);
    }

    public GuiButton(GuiScreen screen, int icon) {
        this(screen);
        this.icon = icon;
    }

    public GuiButton(GuiScreen screen) {
        this.screen = screen;
        this.setSize(50, 10);
    }

    @Override
    public void draw(float partialTicks) {
        this.mouseOver = this.screen.getClickElementAt(this.screen.cursorX, this.screen.cursorY) == this;
        GL11.glDisable((int)3553);
        this.utils.drawRectangle(this.posX, this.posY, this.width, this.height, this.getColor());
        if (this.text != null) {
            GL11.glEnable((int)3553);
            this.utils.drawCenteredString(this.text, this.posX + this.width / 2, this.posY + this.height / 2 - 4, this.getTextColor());
        }
        if (this.icon >= 0) {
            GL11.glEnable((int)3553);
            this.utils.drawIconWithShadow(this.icon, this.posX + this.width / 2 - 4, this.posY + this.height / 2 - 4, this.getTextColor());
        }
    }

    public int getColor() {
        return this.clickable && this.mouseOver ? Colors.buttonBackgroundHover : Colors.buttonBackground;
    }

    public int getTextColor() {
        return this.clickable ? Colors.buttonText : Colors.buttonTextDeactivated;
    }

    @Override
    public void mouseEvent(int button, boolean pressed, int mouseX, int mouseY) {
        if (this.screen.getClickElementAt(mouseX, mouseY) == this && pressed) {
            if (this.clickable) {
                this.utils.playButtonSound();
                this.onClick(button);
            }
            throw new CancelEventException();
        }
    }

    public void onClick(int button) {
        try {
            for (int i = 0; i < this.actionListeners.size(); ++i) {
                this.actionListeners.get(i).actionPerformed(this);
            }
        }
        catch (CancelEventException cancelEventException) {
            // empty catch block
        }
    }

    public GuiButton addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
        return this;
    }

    public GuiButton removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
        return this;
    }

    public GuiButton setClickable(boolean clickable) {
        this.clickable = clickable;
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public boolean isSolid() {
        return this.clickable;
    }
}

