/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.gui;

import b100.minimap.Minimap;
import b100.minimap.gui.CancelEventException;
import b100.minimap.gui.ColorListener;
import b100.minimap.gui.GuiButtonNavigation;
import b100.minimap.gui.GuiContainerBox;
import b100.minimap.gui.GuiElement;
import b100.minimap.gui.GuiNavigationContainer;
import b100.minimap.gui.GuiScreen;
import b100.minimap.gui.GuiTextComponent;
import b100.minimap.gui.GuiTextComponentColor;
import b100.minimap.gui.GuiTextComponentInteger;
import b100.minimap.gui.GuiTextElement;
import b100.minimap.gui.GuiTextField;
import b100.minimap.gui.TextComponentListener;
import b100.minimap.utils.Utils;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.GLAllocation;
import org.lwjgl.opengl.GL11;

public class GuiColorSelectScreen
extends GuiScreen
implements TextComponentListener {
    protected int colorPickerTexture1;
    protected int colorPickerTexture2;
    protected GuiColorBrightnessSaturationElement colorElement1;
    protected GuiColorHueElement colorElement2;
    protected GuiColorPreviewElement colorPreviewElement;
    protected final int previousColor;
    protected int color;
    protected int red;
    protected int green;
    protected int blue;
    protected float hue;
    protected float saturation;
    protected float brightness;
    protected float[] hsb = new float[3];
    public GuiContainerBox container;
    public GuiNavigationContainer navTop;
    public GuiNavigationContainer navBottom;
    public List<ColorListener> colorListeners = new ArrayList<ColorListener>();
    public String title = "Choose Color";
    public GuiTextElement textRed;
    public GuiTextElement textGreen;
    public GuiTextElement textBlue;
    public GuiTextElement textHue;
    public GuiTextElement textSat;
    public GuiTextElement textVal;
    public GuiTextElement textHex;
    public GuiTextComponentInteger textComponentRed;
    public GuiTextComponentInteger textComponentGreen;
    public GuiTextComponentInteger textComponentBlue;
    public GuiTextComponentInteger textComponentHue;
    public GuiTextComponentInteger textComponentSat;
    public GuiTextComponentInteger textComponentVal;
    public GuiTextComponentColor textComponentHex;
    public GuiTextField inputRed;
    public GuiTextField inputGreen;
    public GuiTextField inputBlue;
    public GuiTextField inputHue;
    public GuiTextField inputSat;
    public GuiTextField inputVal;
    public GuiTextField inputHex;
    private boolean updatingColor = false;

    public GuiColorSelectScreen(GuiScreen parentScreen, int color, ColorListener colorListener) {
        super(parentScreen);
        this.colorListeners.add(colorListener);
        this.previousColor = this.color = color;
        this.red = color >> 16 & 0xFF;
        this.green = color >> 8 & 0xFF;
        this.blue = color & 0xFF;
        Color.RGBtoHSB(this.red, this.green, this.blue, this.hsb);
        this.hue = this.hsb[0];
        this.saturation = this.hsb[1];
        this.brightness = this.hsb[2];
    }

    @Override
    public void onInit() {
        this.container = this.add(new GuiContainerBox());
        this.colorElement1 = this.add(new GuiColorBrightnessSaturationElement(this));
        this.colorElement2 = this.add(new GuiColorHueElement(this));
        this.colorPreviewElement = this.add(new GuiColorPreviewElement(this));
        this.navTop = this.add(new GuiNavigationContainer(this, this.container, GuiNavigationContainer.Position.TOP));
        this.navBottom = this.add(new GuiNavigationContainer(this, this.container, GuiNavigationContainer.Position.BOTTOM));
        this.navTop.add(new GuiButtonNavigation(this, this.title, this.container));
        this.navBottom.add(new GuiButtonNavigation(this, "Cancel", this.container).addActionListener(e -> this.back()));
        this.navBottom.add(new GuiButtonNavigation(this, "OK", this.container).addActionListener(e -> this.ok()));
        this.textRed = this.add(new GuiTextElement("R", GuiTextElement.Align.CENTER, GuiTextElement.Align.CENTER));
        this.textGreen = this.add(new GuiTextElement("G", GuiTextElement.Align.CENTER, GuiTextElement.Align.CENTER));
        this.textBlue = this.add(new GuiTextElement("B", GuiTextElement.Align.CENTER, GuiTextElement.Align.CENTER));
        this.textHue = this.add(new GuiTextElement("H", GuiTextElement.Align.CENTER, GuiTextElement.Align.CENTER));
        this.textSat = this.add(new GuiTextElement("S", GuiTextElement.Align.CENTER, GuiTextElement.Align.CENTER));
        this.textVal = this.add(new GuiTextElement("V", GuiTextElement.Align.CENTER, GuiTextElement.Align.CENTER));
        this.textHex = this.add(new GuiTextElement("#", GuiTextElement.Align.CENTER, GuiTextElement.Align.CENTER));
        this.textComponentRed = (GuiTextComponentInteger)new GuiTextComponentInteger(0, (Integer)0, (Integer)255).addTextComponentListener(this);
        this.textComponentGreen = (GuiTextComponentInteger)new GuiTextComponentInteger(0, (Integer)0, (Integer)255).addTextComponentListener(this);
        this.textComponentBlue = (GuiTextComponentInteger)new GuiTextComponentInteger(0, (Integer)0, (Integer)255).addTextComponentListener(this);
        this.textComponentHue = (GuiTextComponentInteger)new GuiTextComponentInteger(0, (Integer)0, (Integer)360).addTextComponentListener(this);
        this.textComponentSat = (GuiTextComponentInteger)new GuiTextComponentInteger(0, (Integer)0, (Integer)100).addTextComponentListener(this);
        this.textComponentVal = (GuiTextComponentInteger)new GuiTextComponentInteger(0, (Integer)0, (Integer)100).addTextComponentListener(this);
        this.textComponentHex = (GuiTextComponentColor)new GuiTextComponentColor(0, false).addTextComponentListener(this);
        this.inputRed = this.add(new GuiTextField((GuiScreen)this, this.textComponentRed));
        this.inputGreen = this.add(new GuiTextField((GuiScreen)this, this.textComponentGreen));
        this.inputBlue = this.add(new GuiTextField((GuiScreen)this, this.textComponentBlue));
        this.inputHue = this.add(new GuiTextField((GuiScreen)this, this.textComponentHue));
        this.inputSat = this.add(new GuiTextField((GuiScreen)this, this.textComponentSat));
        this.inputVal = this.add(new GuiTextField((GuiScreen)this, this.textComponentVal));
        this.inputHex = this.add(new GuiTextField((GuiScreen)this, this.textComponentHex));
        this.updateColorUiElements(true, true, true, true, true);
    }

    public void setColorFromHSV() {
        this.color = Color.HSBtoRGB(this.hue, this.saturation, this.brightness);
        this.red = this.color >> 16 & 0xFF;
        this.green = this.color >> 8 & 0xFF;
        this.blue = this.color & 0xFF;
    }

    public void setColorFromRGB() {
        this.red = Utils.clamp(this.red, 0, 255);
        this.green = Utils.clamp(this.green, 0, 255);
        this.blue = Utils.clamp(this.blue, 0, 255);
        this.color = this.red << 16 | this.green << 8 | this.blue;
        Color.RGBtoHSB(this.red, this.green, this.blue, this.hsb);
        this.hue = this.hsb[0];
        this.saturation = this.hsb[1];
        this.brightness = this.hsb[2];
    }

    public void setColorFromARGB() {
        this.red = this.color >> 16 & 0xFF;
        this.green = this.color >> 8 & 0xFF;
        this.blue = this.color & 0xFF;
        Color.RGBtoHSB(this.red, this.green, this.blue, this.hsb);
        this.hue = this.hsb[0];
        this.saturation = this.hsb[1];
        this.brightness = this.hsb[2];
    }

    public void updateColorUiElements(boolean updateRgbInput, boolean updateHsvInput, boolean updateBrightnessSaturationPicker, boolean updateHuePicker, boolean updateHexInput) {
        this.updatingColor = true;
        if (updateRgbInput) {
            this.textComponentRed.setValue(this.red);
            this.textComponentGreen.setValue(this.green);
            this.textComponentBlue.setValue(this.blue);
        }
        if (updateHsvInput) {
            this.textComponentHue.setValue((int)(this.hue * 360.0f));
            this.textComponentSat.setValue((int)(this.saturation * 100.0f));
            this.textComponentVal.setValue((int)(this.brightness * 100.0f));
        }
        if (updateBrightnessSaturationPicker || updateHuePicker) {
            this.updateColorPickerTextures();
        }
        if (updateHexInput) {
            this.textComponentHex.setColor(this.color);
        }
        this.updatingColor = false;
    }

    @Override
    public void onResize() {
        int paddingOuter = 3;
        int paddingInner = 3;
        int size1 = 128;
        int size2 = 8;
        int size3 = 32;
        int innerWidth = size1 * 2 + size2 + 6;
        int innerHeight = size1;
        int width = innerWidth + 6;
        int height = innerHeight + 6;
        this.container.setPosition((this.width - width) / 2, (this.height - height) / 2).setSize(width, height);
        int innerPosX = this.container.posX + 3;
        int innerPosY = this.container.posY + 3;
        this.colorElement1.setPosition(innerPosX, innerPosY).setSize(size1, size1);
        this.colorElement2.setPosition(innerPosX + size1 + 3, innerPosY).setSize(size2, size1);
        int x1 = innerPosX + size1 + size2 + 6;
        int x2 = x1 + size1 / 2;
        int y1 = innerPosY + size3 + 3;
        this.colorPreviewElement.setPosition(x1 + (size1 - size3) / 2, innerPosY).setSize(size3, size3);
        int lineHeight = 10;
        int lineHeightPad = lineHeight + 1;
        this.textHue.setPosition(x1, y1 + 1 * lineHeightPad).setSize(lineHeight, lineHeight);
        this.textSat.setPosition(x1, y1 + 2 * lineHeightPad).setSize(lineHeight, lineHeight);
        this.textVal.setPosition(x1, y1 + 3 * lineHeightPad).setSize(lineHeight, lineHeight);
        this.inputHue.setPosition(x1 + lineHeight + 3, y1 + 1 * lineHeightPad).setSize(32, lineHeight);
        this.inputSat.setPosition(x1 + lineHeight + 3, y1 + 2 * lineHeightPad).setSize(32, lineHeight);
        this.inputVal.setPosition(x1 + lineHeight + 3, y1 + 3 * lineHeightPad).setSize(32, lineHeight);
        this.textRed.setPosition(x2, y1 + 1 * lineHeightPad).setSize(lineHeight, lineHeight);
        this.textGreen.setPosition(x2, y1 + 2 * lineHeightPad).setSize(lineHeight, lineHeight);
        this.textBlue.setPosition(x2, y1 + 3 * lineHeightPad).setSize(lineHeight, lineHeight);
        this.inputRed.setPosition(x2 + lineHeight + 3, y1 + 1 * lineHeightPad).setSize(32, lineHeight);
        this.inputGreen.setPosition(x2 + lineHeight + 3, y1 + 2 * lineHeightPad).setSize(32, lineHeight);
        this.inputBlue.setPosition(x2 + lineHeight + 3, y1 + 3 * lineHeightPad).setSize(32, lineHeight);
        this.textHex.setPosition(x1, y1 + 5 * lineHeightPad).setSize(lineHeight, lineHeight);
        this.inputHex.setPosition(x1 + lineHeight + 3, y1 + 5 * lineHeightPad).setSize(64, lineHeight);
        super.onResize();
    }

    public void ok() {
        for (int i = 0; i < this.colorListeners.size(); ++i) {
            try {
                this.colorListeners.get(i).onColorChanged(this, this.color);
                continue;
            }
            catch (CancelEventException cancelEventException) {
                // empty catch block
            }
        }
        this.back();
    }

    @Override
    public void onGuiOpened() {
        this.createTextures();
    }

    @Override
    public void onGuiClosed() {
        this.deleteTextures();
    }

    public void updateColorPickerTextures() {
        int i;
        if (this.colorPickerTexture1 == 0 || this.colorPickerTexture2 == 0) {
            Minimap.log("Cannot update gradient texture because texture doesnt exist!");
            return;
        }
        int res = 256;
        float resMinus1 = 255.0f;
        int size1 = 262144;
        int size2 = 1024;
        int sizeTotal = 263168;
        ByteBuffer buffer = this.minimap.minecraftHelper.getBufferWithCapacity(263168);
        buffer.position(0).limit(262144);
        for (i = 0; i < 256; ++i) {
            float brightness = 1.0f - (float)i / 255.0f;
            for (int j = 0; j < 256; ++j) {
                float saturation = (float)j / 255.0f;
                int color = Color.HSBtoRGB(this.hue, saturation, brightness);
                byte a = (byte)(color >> 24);
                byte r = (byte)(color >> 16);
                byte g = (byte)(color >> 8);
                byte b = (byte)(color >> 0);
                buffer.put(r);
                buffer.put(g);
                buffer.put(b);
                buffer.put(a);
            }
        }
        buffer.position(262144).limit(263168);
        for (i = 0; i < 256; ++i) {
            int color = Color.HSBtoRGB(1.0f - (float)i / 255.0f, 1.0f, 1.0f);
            byte a = (byte)(color >> 24);
            byte r = (byte)(color >> 16);
            byte g = (byte)(color >> 8);
            byte b = (byte)(color >> 0);
            buffer.put(r);
            buffer.put(g);
            buffer.put(b);
            buffer.put(a);
        }
        boolean filter = false;
        int filterMode = filter ? 9729 : 9728;
        buffer.position(0).limit(262144);
        GL11.glBindTexture((int)3553, (int)this.colorPickerTexture1);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)256, (int)256, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        GL11.glTexParameteri((int)3553, (int)10241, (int)filterMode);
        GL11.glTexParameteri((int)3553, (int)10240, (int)filterMode);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        buffer.position(262144).limit(263168);
        GL11.glBindTexture((int)3553, (int)this.colorPickerTexture2);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)1, (int)256, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        GL11.glTexParameteri((int)3553, (int)10241, (int)filterMode);
        GL11.glTexParameteri((int)3553, (int)10240, (int)filterMode);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
    }

    public void createTextures() {
        if (this.colorPickerTexture1 == 0) {
            this.colorPickerTexture1 = GLAllocation.generateTexture();
        }
        if (this.colorPickerTexture2 == 0) {
            this.colorPickerTexture2 = GLAllocation.generateTexture();
        }
    }

    public void deleteTextures() {
        if (this.colorPickerTexture1 != 0) {
            GL11.glDeleteTextures((int)this.colorPickerTexture1);
            GLAllocation.textureNames.remove((Object)this.colorPickerTexture1);
            this.colorPickerTexture1 = 0;
        }
        if (this.colorPickerTexture2 != 0) {
            GL11.glDeleteTextures((int)this.colorPickerTexture2);
            GLAllocation.textureNames.remove((Object)this.colorPickerTexture2);
            this.colorPickerTexture2 = 0;
        }
    }

    @Override
    public void onTextComponentChanged(GuiTextComponent textComponent) {
        if (this.updatingColor) {
            return;
        }
        if (textComponent == this.textComponentRed) {
            this.red = this.textComponentRed.getValue();
            this.setColorFromRGB();
            this.updateColorUiElements(false, true, true, true, true);
        }
        if (textComponent == this.textComponentGreen) {
            this.green = this.textComponentGreen.getValue();
            this.setColorFromRGB();
            this.updateColorUiElements(false, true, true, true, true);
        }
        if (textComponent == this.textComponentBlue) {
            this.blue = this.textComponentBlue.getValue();
            this.setColorFromRGB();
            this.updateColorUiElements(false, true, true, true, true);
        }
        if (textComponent == this.textComponentHue) {
            this.hue = (float)this.textComponentHue.getValue() / 360.0f;
            this.setColorFromHSV();
            this.updateColorUiElements(true, false, true, true, true);
        }
        if (textComponent == this.textComponentSat) {
            this.saturation = (float)this.textComponentSat.getValue() / 100.0f;
            this.setColorFromHSV();
            this.updateColorUiElements(true, false, true, true, true);
        }
        if (textComponent == this.textComponentVal) {
            this.brightness = (float)this.textComponentVal.getValue() / 100.0f;
            this.setColorFromHSV();
            this.updateColorUiElements(true, false, true, true, true);
        }
        if (textComponent == this.textComponentHex) {
            this.color = this.textComponentHex.getColor();
            this.setColorFromARGB();
            this.updateColorUiElements(true, true, true, true, false);
        }
    }

    public static class GuiColorBrightnessSaturationElement
    extends GuiColorElement {
        public GuiColorBrightnessSaturationElement(GuiColorSelectScreen screen) {
            super(screen);
        }

        @Override
        public void draw(float partialTicks) {
            super.draw(partialTicks);
            int selectionX = (int)((float)this.posX + this.screen.saturation * (float)(this.width - 1));
            int selectionY = (int)((float)this.posY + (1.0f - this.screen.brightness) * (float)(this.height - 1));
            GL11.glDisable((int)3553);
            this.utils.drawRectangle(selectionX, selectionY, 1, 1, -1);
            this.utils.drawRectangle(selectionX - 1, selectionY, 1, 1, -16777216);
            this.utils.drawRectangle(selectionX + 1, selectionY, 1, 1, -16777216);
            this.utils.drawRectangle(selectionX, selectionY - 1, 1, 1, -16777216);
            this.utils.drawRectangle(selectionX, selectionY + 1, 1, 1, -16777216);
        }

        @Override
        public int getTexture() {
            return this.screen.colorPickerTexture1;
        }

        @Override
        public void updateColor(int mouseX, int mouseY) {
            this.screen.saturation = Utils.clamp((float)(mouseX - this.posX) / (float)this.width, 0.0f, 1.0f);
            this.screen.brightness = 1.0f - Utils.clamp((float)(mouseY - this.posY) / (float)this.height, 0.0f, 1.0f);
            this.screen.setColorFromHSV();
            this.screen.updateColorUiElements(true, true, false, true, true);
        }
    }

    public static class GuiColorHueElement
    extends GuiColorElement {
        public GuiColorHueElement(GuiColorSelectScreen screen) {
            super(screen);
        }

        @Override
        public void draw(float partialTicks) {
            super.draw(partialTicks);
            int selectionY = (int)((float)this.posY + (1.0f - this.screen.hue) * (float)(this.height - 1));
            GL11.glDisable((int)3553);
            this.utils.drawRectangle(this.posX, selectionY, this.width, 1, -16777216);
        }

        @Override
        public int getTexture() {
            return this.screen.colorPickerTexture2;
        }

        @Override
        public void updateColor(int mouseX, int mouseY) {
            this.screen.hue = 1.0f - Utils.clamp((float)(mouseY - this.posY) / (float)this.height, 0.0f, 1.0f);
            this.screen.setColorFromHSV();
            this.screen.updateColorUiElements(true, true, true, false, true);
        }
    }

    public static class GuiColorPreviewElement
    extends GuiElement {
        public GuiColorSelectScreen screen;

        public GuiColorPreviewElement(GuiColorSelectScreen screen) {
            this.screen = screen;
        }

        @Override
        public void draw(float partialTicks) {
            int heightHalf = this.height / 2;
            GL11.glDisable((int)3553);
            this.utils.drawRectangle(this.posX, this.posY, this.width, heightHalf, this.screen.color | 0xFF000000);
            this.utils.drawRectangle(this.posX, this.posY + heightHalf, this.width, this.height - heightHalf, this.screen.previousColor | 0xFF000000);
        }
    }

    public static abstract class GuiColorElement
    extends GuiElement {
        public GuiColorSelectScreen screen;
        protected boolean dragging = false;

        public GuiColorElement(GuiColorSelectScreen screen) {
            this.screen = screen;
        }

        @Override
        public void draw(float partialTicks) {
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
            GL11.glBindTexture((int)3553, (int)this.getTexture());
            this.utils.drawTexturedRectangle(this.posX, this.posY, this.width, this.height, 0.0f, 0.0f, 1.0f, 1.0f, -1);
            GL11.glEnable((int)3042);
            if (this.dragging) {
                this.updateColor(this.screen.cursorX, this.screen.cursorY);
            }
        }

        @Override
        public void mouseEvent(int button, boolean pressed, int mouseX, int mouseY) {
            if (pressed && this.screen.getClickElementAt(mouseX, mouseY) == this) {
                this.dragging = true;
                this.updateColor(mouseX, mouseY);
            }
            if (!pressed && this.dragging) {
                this.dragging = false;
                this.updateColor(mouseX, mouseY);
            }
        }

        public abstract int getTexture();

        public abstract void updateColor(int var1, int var2);
    }
}

