/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.gui;

import b100.minimap.config.Option;
import b100.minimap.gui.CancelEventException;
import b100.minimap.gui.GuiButton;
import b100.minimap.gui.GuiScreen;
import b100.minimap.gui.OptionListener;
import java.util.ArrayList;
import java.util.List;

public abstract class GuiOptionButton<E>
extends GuiButton {
    public Option<E> option;
    public List<OptionListener> optionListeners = new ArrayList<OptionListener>();

    public GuiOptionButton(GuiScreen screen, Option<E> option) {
        super(screen);
        this.option = option;
        if (option == null) {
            throw new NullPointerException();
        }
        this.updateText();
    }

    public void updateText() {
        this.text = this.getOptionValueString();
    }

    public String getOptionValueString() {
        return this.option.value.toString();
    }

    public void onOptionValueChanged() {
        this.updateText();
        try {
            for (int i = 0; i < this.optionListeners.size(); ++i) {
                this.optionListeners.get(i).onOptionValueChanged(this.option);
            }
        }
        catch (CancelEventException cancelEventException) {
            // empty catch block
        }
    }

    public GuiOptionButton<E> addOptionListener(OptionListener optionListener) {
        this.optionListeners.add(optionListener);
        return this;
    }

    public GuiOptionButton<E> removeOptionListener(OptionListener optionListener) {
        this.optionListeners.remove(optionListener);
        return this;
    }
}

